  subroutine rddingle_soa(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=25,nlab=31
  integer :: noprf,ilab
  real :: wcmdat(ndat),wavedat(ndat),rnval(ndat),rival(ndat)
  character(len=60) :: fil
  character(len=50) :: labstr(nlab)
  character(len=16) :: llset

! ***
! Read in the data from the ascii file
   lset=lstrn

!       '1234567890123456'
  llset='dingle_soa      '

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/dingle_soa.dat                                 '
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then  
!   stop
  end if

! *****
! Reference: Justin H. Dingle, Stephen Zimmerman, Alexander L. Frie,
! Justin Min, Heejung Jung and Roya Bahreini
! Complex refractive index, single scattering albedo, and mass
! absorption coefficient of secondary organic aerosols generated from
! oxidation of biogenic and anthropogenic precursors
! Aer Sci Tech, v53, 449-463, 2019
! https://doi.org/10.1080/02786826.2019.1571680
!
! Real and Imaginary Refractive Indices of SOA Aerosol
!
! Contact: Steven Massie (Steven.Massie@lasp.colorado.edi)
!
! Laboratory conditions
!    1,  Lgf     H2O2     48±4      30±1         I
!    2,  Lgf     H2O2     37±3      10±1         II
!    3,  Lgf     HONO     86±3      0.1±0.1      III
!    4,  Lgf     HONO     76±1      0.09±0.01    IV
!    5,  a-P     H2O2     110±7     22±1         I
!    6,  a-P     H2O2     129±3     12±2         II
!    7,  a-P     H2O2     48±2      4±1          III
!    8,  a-P     H2O2     40±1      4±1          IV
!    9,  1-MN    H2O2     80±5      21±3         I
!   10,  1-MN    H2O2     61±75     ±1           II
!   11,  1-MN    H2O2     54±5      4±1          III
!   12,  1-MN    H2O2     22±13     ±0.1         IV
!   13,  1-MN    HONO     300±20    0.4±0.008    V
!   14,  1-MN    HONO     240±5     0.3±0.004    VI
!   15,  Phe     H2O2     210±2     60±1         I
!   16,  Phe     H2O2     160±4     27±1         II
!   17,  Phe     H2O2     31±2      10±1         III
!   18,  Phe     HONO     120±6     0.2±0.003    IV
!   19,  Phe     HONO     110±5     0.1±0.002    V
!   20,  Tol     H2O2     270±5     55±4         I
!   21,  Tol     H2O2     240±3     50±1         II
!   22,  Tol     H2O2     72±1      N/A          III
!   23,  Tol     H2O2     43±3      18±2         IV
!   24,  Tol     HONO     163±20    0.2±0.02     V
!   25,  Tol     HONO     110±7     0.1±0.04     VI

!  nlines       25
!  j,wcm375(j),wavelength375(j),rn375(j),ri375(j),wcm632(j),wavelength632(j),rn632(j)
!  1  26666.6660  0.3750   1.4500   0.0000   15822.7842   0.6320 1.49
!  2  26666.6660  0.3750   1.4800   0.0000   15822.7842   0.6320 1.48

! *****
! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,13
   read(idat,fmt=100) header
  end do
  100 format(a80)

   nlines=ndat
  do i=1,nlab
   read(idat,fmt=102) labstr(i)
  end do
  102 format(a50)

   do i=1,3
    read(idat,fmt=100) header
   end do
   do i=1,nlines
    read(idat,*) j,wcmdat(i),wavedat(i),rnval(i),rival(i),w632,wave632,rn632
   end do

  close (idat)

! *****
! Will select the labooratory condition to work with
  do i=1,nlab
   write(0,fmt=102) labstr(i)
  end do

  write(0,fmt=140)
  140 format(2x,"Specify ilab 1 to 25")
  read(5,*) ilab

  write(0,fmt=165) ilab
  165 format(2x," will use ilab ",i2)

! *****
! Put values into the output arrays
    nlines=1
  do i=1,nlines
   wcm(i)=wcmdat(ilab)
   wavelength(i)=wavedat(ilab)
   rndat(i)=rnval(ilab)
   ridat(i)=rival(ilab)
  end do

! *****
  if (nopr .eq. 1) then

   write(iout,fmt=200) nlines,fil
   200 format(/,2x,"rddingle_soa: nlines,fil",/,&
   2x,i4,2x,a60)
   write(iout,fmt=230)
   230 format(2x,"rddingle_soa: i,wcm,wavelength,rndat and ridat")
   do i=1,nlines
    write(iout,fmt=240) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    240 format(2x,i4,1p,2(1x,e10.3),2x,2(1x,e10.3))
   end do

  end if

! ******
  return
  end


