  subroutine rdgrainger_volcanic_ash(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ***
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=2054
  real :: wcmdat(ndat),wavedat(ndat)
  real :: rnval(ndat),rival(ndat)
  real :: rnerr,rierr
  character(len=60) :: fil
  character (len=16) :: llset

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/grainger_volcanic_ash.dat                      '
!       '1234567890123456'
  llset='gr_volcanic_ash '

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! ***

!Data: Ash volcanic refractive indices from 1 to 20 microns

!Reference:
!Grainger, R. G., Peters, D. M., Thomas, G. E., Smith, A. J. A.,
!Siddans, R., Carboni, E., and Dudhia, A.: Measuring Volcanic
!Plume and Ash Properties from Space, in: Remote Sensing of
!Volcanoes and Volcanic Processes: Integrating Observation and
!Modelling, edited by Pyle, D. and Mather, T., vol. 270 of Special
!Publications, Geological Society, London, 2012.

!Contact: R. G. Grainger (R.Grainger@physics.ox.ac.uk)

!Format: 2054 lines 2x,2(1x,f8.2),4(1x,f10.4)
!        The realerr and imaginaryerr are errors in percent

!     cm-1    microns     real    imaginary   realerr imaginaryerr
!    400.00    25.00     1.9382     7.3998    -3.1283     3.0426
!    401.00    24.94     1.9051     6.9245    -3.0994     2.7995
!    402.00    24.88     1.8734     6.4836    -3.0705     2.5899

! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,17
   read(idat,fmt=100) header
  end do
  100 format(a80)

  nlines=ndat

   do i=1,nlines
    read(idat,*) wcm(i),wavelength(i),rndat(i),ridat(i),rnerr,rierr
   end do

  close (idat)

! *****
! Put values into the output arrays
! do i=1,nlines
!  rndat(i)=rnval(i)
!  ridat(i)=rival(i)
! end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=840)
    840 format(/,2x,"rdgrainger_volcanic_ash: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f10.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
