  subroutine rdjager_mg2sio4(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=4847
  integer :: noprf
  real :: wcmdat(ndat),wavedat(ndat),rnval(ndat),rival(ndat)
  character(len=60) :: fil
  character(len=16) :: llset

! ***
! Read in the data from the ascii file
   lset=lstrn

!       '1234567890123456'
  llset='jager mg2sio4   '

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='exoplanets/jager_mg2sio4.dat                                '
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then  
!  stop
  end if

! *****
! Reference: Jager, C., J. Dorschner, H. Mutschke, Th. Posch,
! Th. Henning, Steps toward interstellar silicate mineralogy
! VII. Spectral properties and crystallization behaviour of magnesium
! silicates produced by the sol-gel method
! Astronomy and Astrophysics, v408, p193-204, 2003
!
! Real and Imaginary Refractive Indices of Mg2SiO4
!
! Contact: Cornelia Jager (cornelia.jaeger@uni-jena.de)
!
! Format: 4847 lines 2x,2(1x,f11.5),2(1x,f10.4)
!
!       cm-1        microns      real     imaginary
!   51100.06250     0.19569     1.7448     0.0083
!   51089.51953     0.19573     1.7444     0.0082

! *****
! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,13
   read(idat,fmt=100) header
  end do
  100 format(a80)

   nlines=ndat

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),rnval(i),rival(i)
!   wavedat(i)=1.0e4/wcmdat(i)
   end do

  close (idat)

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i)
   ridat(i)=rival(i)
  end do

! *****
  if (nopr .eq. 1) then

   write(iout,fmt=200) nlines,fil
   200 format(/,2x,"rdjager_ng2sio4: nlines,fil",/,&
   2x,i4,2x,a60)
   write(iout,fmt=230)
   230 format(2x,"rdjager_mg2sio4: i,wcm,wavelength,rndat and ridat")
   do i=1,nlines
    write(iout,fmt=240) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    240 format(2x,i4,1p,2(1x,e12.5),2x,2(1x,e10.3))
   end do

  end if

! ******
  return
  end


