  subroutine rdlistrn(nopr,iout,indir,nsets,listrn)

! *************************
! Output
!  nsets
!  listrn(nsets)
  integer :: nsets
  integer,parameter :: nfmax=100
  character(len=100) :: listrn(nfmax)

! **
! See rdinoutdir.f90 and main.f90
  integer :: nopr,iout,idat
  character(len=60) :: indir

! **
! Used here
  integer :: iadd
  character(len=11) :: file
  character(len=80) :: header
  character(len=80) :: blankline
  character(len=30) :: filnm

! **
! Will need to change
  character(len=33) :: str33
  character(len=1) :: blnk

! *************************
! This file has the pathnames of the refractive index sets
!       '12345678901'
   file='indices.dat'

! Open the file
    idat=30
  open(idat,form='formatted',file='indices.dat',status='unknown')

  read(idat,fmt=100) header
  read(idat,fmt=*) nsets
  read(idat,fmt=100) header
  100 format(a80)

! ******
! There are nsets refractive index files
! Check
  if (nsets .lt. 1) then 
   write(iout,fmt=200)
   200 format(/)
   write(iout,fmt=210) nsets
   210 format(2x," rdlistrn: nsets lt 1, will stop",/,2x,i4)
   stop
  end if
    
! *****
! Read in the files
    i1=1
    i2=nsets
   do i=i1,i2 
    read(idat,fmt=300) j,filnm
    300 format(i2,1x,a30)
    listrn(i)=filnm
   end do

! Close the indices.dat input file
   close (idat)

! *************************
! Write out the index files and identifiers
  if (nopr .eq. 1) then 
   write(iout,fmt=400)
   400 format(/)
   write(iout,fmt=405) nsets
   405 format(2x,"rdlistrn: nsets ",i4)
   write(iout,fmt=410)
   410 format(2x,"rdlistrn: i,filnms(i)")
   do i=1,10
    i2=i-1
    write(iout,fmt=430) i2,listrn(i)
!   430 format(2x,i2,3x,a100)
    430 format(2x,i2,3x,a32)
   end do
   do i=11,nsets
    i2=i-1
    write(iout,fmt=432) i2,listrn(i)
!   432 format(2x,i2,2x,a100)
    432 format(2x,i2,2x,a32)
   end do
  end if

! *************************
  return
  end
