  subroutine rdnorman_hno3(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ***
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=2047,nwt=5
  real :: wghts(nwt),whno3(nwt)
  real :: wcmdat(ndat),wavedat(ndat)
! Note that the ndat,nt is opposite to the ncdump dump
  real :: rnval(ndat,nwt),rival(ndat,nwt)
  character(len=60) :: fil
  character (len=16) :: llset,files(nwt)

! The four temperatures of interest
  wghts(1)=35.0
  wghts(2)=45.0
  wghts(3)=54.0
  wghts(4)=63.0
  wghts(5)=70.0
!         '1234567890123456'
  files(1)=' 35% HNO3      '
  files(2)=' 45% HNO3      '
  files(3)=' 54% HNO3      '
  files(4)=' 63% HNO3      '
  files(5)=' 70% HNO3      '

! ***
! Will specify which temperature to work with

  write(0,fmt=140)
  140 format(2x," Will select iwt=1,2,3,4,5 for 35, 45, 54, 63, 70")

  write(0,fmt=160)
  160 format(2x,"Specify iwt ")

  read(5,*) iwt
  iwt=int(iwt)

  if ((iwt .lt. 0) .or. (iwt .gt. nwt)) then
   write(0,fmt=162)
   162 format(/,2x,"rdnorman_hno3: iwt is wrong, will stop, iwt ",i4)
   stop
  end if

! The compound string
  llset=files(iwt)

  write(0,fmt=170) iwt,llset
  170 format(2x," iwt,llset ",i4,2x,a16)

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/norman_hno3_h2o.dat                            '

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! ***
! Open the input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,17
   read(idat,fmt=100) header
  end do
  100 format(a80)

  nlines=ndat

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),(rnval(i,j),j=1,nwt)
   end do

  do i=1,3
   read(idat,fmt=100) header
  end do

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),(rival(i,j),j=1,nwt)
   end do

  close (idat)

! *****
! Put values into the output arrays
   nlines=ndat
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i,iwt)
   ridat(i)=rival(i,iwt)
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=839) iwt,wghts(iwt)
    839 format(/,2x,"rdnorman_hno3: iwt,wghts(iwt) ",i3,2x,f10.4)
    write(iout,fmt=840)
    840 format(/,2x,"rdnorman_hno3: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f10.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
