  subroutine rdramirez_titan_aerosol(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=161
  integer :: noprf
  real :: wcmdat(ndat),wavedat(ndat),rnval(ndat),rival(ndat)
  character(len=60) :: fil
  character(len=16) :: llset

! ***
! Read in the data from the ascii file
   lset=lstrn

!       '1234567890123456'
  llset='ramirez titan   '

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='exoplanets/ramirez_titan_aerosol.dat                        '
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then  
!   stop
  end if

! *****
! Reference: Ramirez, S. I, P.Coll, A. da Silva, R. Navarro-Gonzalez,
! J. Lafait, and F. Raulin
! Complex Refractive Index of Titan s Aerosol Analogues in the
! 200-900 nm Domain
! Icarus, v146, 515-529, 2002
!
! Real and Imaginary Refractive Indices of Titan Aerosol
!
! Contact: S. I. Ramirez (ramirez@lisa.univ-paris12.fr)
!
! Format: 161 lines 2x,1(1x,e11.4),1(1x,f10.4),2(1x,f10.4)
!
!       cm-1        microns     real    imaginary
!    5.0125e+04     0.1995     1.6805     0.0197
!    4.8900e+04     0.2045     1.6671     0.0202

! *****
! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,13
   read(idat,fmt=100) header
  end do
  100 format(a80)

   nlines=ndat

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),rnval(i),rival(i)
    wavedat(i)=1.0e4/wcmdat(i)
   end do

  close (idat)
 
! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i)
   ridat(i)=rival(i)
  end do

! *****
  if (nopr .eq. 1) then

   write(iout,fmt=200) nlines,fil
   200 format(/,2x,"rdramirez_titan_aerosol: nlines,fil",/,&
   2x,i4,2x,a60)
   write(iout,fmt=230)
   230 format(2x,"rdramirez_titan_aerosol: i,wcm,wavelength,rndat and ridat")
   do i=1,nlines
    write(iout,fmt=240) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    240 format(2x,i4,1p,2(1x,e10.3),2x,2(1x,e10.3))
   end do

  end if

! ******
  return
  end


