   pro rdmagi_biomass_fire,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file
  fil=strarr(1)
  fil='magi_biomass_fire.nc'
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnwave=ncdf_varid(nc_id,'nwave')
  idndays=ncdf_varid(nc_id,'ndays')
  idwcmobs=ncdf_varid(nc_id,'wcmobs')
  idwmicobs=ncdf_varid(nc_id,'wmicobs')
  idrn=ncdf_varid(nc_id,'rn')
  idri=ncdf_varid(nc_id,'ri')
  idrnerr=ncdf_varid(nc_id,'rnerr')
  idrierr=ncdf_varid(nc_id,'rierr')
  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idnwave,nwave
  ncdf_varget,nc_id,idwcmobs,wcmobs
  ncdf_varget,nc_id,idwmicobs,wmicobs
  ncdf_varget,nc_id,idrn,rn
  ncdf_varget,nc_id,idri,ri
  ncdf_varget,nc_id,idrnerr,rnerr
  ncdf_varget,nc_id,idrierr,rierr

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; ****
; Read in the day of interest
  print,'  '  
  print,'  rdmagi biomass fire'
  print,'  iday=0,1,2 are 22 Aug 2000, 24 Aug 2000, 31 Aug 2000'
  print,'  iday=3,4,5 are 3 Sep 2000, 6 Sep 2000, 6 Sep 2000'
  print,'  Specify iday'

  read,iday

; *****
; For graphs
  iiday=iday+10
  nstart=0
  npos=17
  casestr=strmid(text(iiday),nstart,npos)
  lset=strcompress(lstrn+' '+casestr)

; *****
   nlines=nwave
  rndat=fltarr(nlines)
  ridat=fltarr(nlines)
  wcm=fltarr(nlines)
  wavelength=fltarr(nlines)
  for i=0,nlines-1 do begin
   rndat(i)=rn(i,iday)
   ridat(i)=ri(i,iday)
   wcm(i)=wcmobs(i)
   wavelength(i)=wmicobs(i)
  endfor

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdrichwine_nat: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdrichwine_nat: i,wcm,wavelength,rndat and ridat'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end


