   pro rdshettle,nopr,iout,filnm,$
   ntext,text,$
   nlines,wcm,wavelength,rn,ri,llset

; ******
; Read in the data from the netCDF file

; ***
; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')

  idnlines1=ncdf_varid(nc_id,'nlines1')
  idnlines2=ncdf_varid(nc_id,'nlines2')
  idnlines3=ncdf_varid(nc_id,'nlines3')
  idnlines4=ncdf_varid(nc_id,'nlines4')
  idnlines5=ncdf_varid(nc_id,'nlines5')

  idn80=ncdf_varid(nc_id,'n80')
  idn16=ncdf_varid(nc_id,'n16')
  idncomp=ncdf_varid(nc_id,'ncomp')

  idtext=ncdf_varid(nc_id,'text')
  idfiles=ncdf_varid(nc_id,'files')

; Get variables
  ncdf_varget,nc_id,idn80,n80
  ncdf_varget,nc_id,idn16,n16
  ncdf_varget,nc_id,idncomp,ncomp

; ***
; Obtain the listing of the compounds
; Will ask the user to choose which compound to work with

  ncdf_varget,nc_id,idfiles,files
  files=string(files)

; *
   print,'  '
   print,'  rdshettle: ncomp ',ncomp
   print,'  rdshettle: i,files(i)'
  for i=0,ncomp-1 do begin
   print,'  ',i,'  ',files(i)
  endfor

  print,'  specify the mset set to work with   e.g. mset=7 for volcanic dust'
  read,mset
  mset=fix(mset)

  print,'  mset = ',mset
  print,'  files(mset) ',files(mset)

  llset=strarr(1)
  llset=files(mset)

; ***
; Original text from Shettle's ascii file
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ***
; Obtain the specific indices

  if ((mset ge 0) and (mset le 3)) then begin
    ncdf_varget,nc_id,idnlines1,nlines
    idwcm=ncdf_varid(nc_id,'wcm1')
    idwav=ncdf_varid(nc_id,'wavelength1')
    ncdf_varget,nc_id,idwcm,wcm
    ncdf_varget,nc_id,idwav,wavelength
   if (mset eq 0) then begin
    idrn=ncdf_varid(nc_id,'watern')
    idri=ncdf_varid(nc_id,'wateri')
   endif
   if (mset eq 1) then begin
    idrn=ncdf_varid(nc_id,'icen')
    idri=ncdf_varid(nc_id,'icei')
   endif
   if (mset eq 2) then begin
    idrn=ncdf_varid(nc_id,'nacln')
    idri=ncdf_varid(nc_id,'nacli')
   endif
   if (mset eq 3) then begin
    idrn=ncdf_varid(nc_id,'seasaltn')
    idri=ncdf_varid(nc_id,'seasalti')
   endif
  endif

  if ((mset ge 4) and (mset le 6)) then begin
    ncdf_varget,nc_id,idnlines2,nlines
    idwcm=ncdf_varid(nc_id,'wcm2')
    idwav=ncdf_varid(nc_id,'wavelength2')
    ncdf_varget,nc_id,idwcm,wcm
    ncdf_varget,nc_id,idwav,wavelength
   if (mset eq 4) then begin
    idrn=ncdf_varid(nc_id,'water_solublen')
    idri=ncdf_varid(nc_id,'water_solublei')
   endif
   if (mset eq 5) then begin
    idrn=ncdf_varid(nc_id,'ammoniumn')
    idri=ncdf_varid(nc_id,'ammoniumi')
   endif
   if (mset eq 6) then begin
    idrn=ncdf_varid(nc_id,'carbonaceousn')
    idri=ncdf_varid(nc_id,'carbonaceousi')
   endif
  endif

  if ((mset ge 7) and (mset le 10)) then begin
    ncdf_varget,nc_id,idnlines3,nlines
    idwcm=ncdf_varid(nc_id,'wcm3')
    idwav=ncdf_varid(nc_id,'wavelength3')
    ncdf_varget,nc_id,idwcm,wcm
    ncdf_varget,nc_id,idwav,wavelength
   if (mset eq 7) then begin
    idrn=ncdf_varid(nc_id,'volcanic_dustn')
    idri=ncdf_varid(nc_id,'volcanic_dusti')
   endif
   if (mset eq 8) then begin
    idrn=ncdf_varid(nc_id,'h2so4215n')
    idri=ncdf_varid(nc_id,'h2so4215i')
   endif
   if (mset eq 9) then begin
    idrn=ncdf_varid(nc_id,'h2so4300n')
    idri=ncdf_varid(nc_id,'h2so4300i')
   endif
   if (mset eq 10) then begin
    idrn=ncdf_varid(nc_id,'meteor_dustn')
    idri=ncdf_varid(nc_id,'meteor_dusti')
   endif
  endif

  if ((mset ge 11) and (mset le 14)) then begin
    ncdf_varget,nc_id,idnlines4,nlines
    idwcm=ncdf_varid(nc_id,'wcm4')
    idwav=ncdf_varid(nc_id,'wavelength4')
    ncdf_varget,nc_id,idwcm,wcm
    ncdf_varget,nc_id,idwav,wavelength
   if (mset eq 11) then begin
    idrn=ncdf_varid(nc_id,'quartz_orayn')
    idri=ncdf_varid(nc_id,'quartz_orayi')
   endif
   if (mset eq 12) then begin
    idrn=ncdf_varid(nc_id,'quartz_erayn')
    idri=ncdf_varid(nc_id,'quartz_erayi')
   endif
   if (mset eq 13) then begin
    idrn=ncdf_varid(nc_id,'hematite_orayn')
    idri=ncdf_varid(nc_id,'hematite_orayi')
   endif
   if (mset eq 14) then begin
    idrn=ncdf_varid(nc_id,'hematite_erayn')
    idri=ncdf_varid(nc_id,'hematite_erayi')
   endif
  endif

  if ((mset ge 15) and (mset le 17)) then begin
    ncdf_varget,nc_id,idnlines5,nlines
    idwcm=ncdf_varid(nc_id,'wcm5')
    idwav=ncdf_varid(nc_id,'wavelength5')
    ncdf_varget,nc_id,idwcm,wcm
    ncdf_varget,nc_id,idwav,wavelength
   if (mset eq 15) then begin
    idrn=ncdf_varid(nc_id,'sand_orayn')
    idri=ncdf_varid(nc_id,'sand_orayi')
   endif
   if (mset eq 16) then begin
    idrn=ncdf_varid(nc_id,'sand_erayn')
    idri=ncdf_varid(nc_id,'sand_erayi')
   endif
   if (mset eq 17) then begin
    idrn=ncdf_varid(nc_id,'dust_liken')
    idri=ncdf_varid(nc_id,'dust_likei')
   endif
  endif

; ****
;  Read in the real and imaginary indices
   ncdf_varget,nc_id,idrn,rn
   ncdf_varget,nc_id,idri,ri

; ****
; Close the data set
  ncdf_close,nc_id

; *****
; Be careful, some sets have 0 for real and imaginary
   mlines=0
   for i=0,nlines-1 do begin
    if (rn(i) gt 0.0) then begin
     mlines=mlines+1
    endif
   endfor
   nlines=mlines

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdshettle: work with   mset,files(mset)'
    printf,iout,'  ',mset,'  ',files(mset)
    printf,iout,'  rdshettle: files(i)'
   for i=0,ncomp-1 do begin
    printf,iout,'  ',i,' ',files(i)
   endfor

    iwrtext=0
   if (iwrtext eq 1) then begin
    printf,iout,'  '
    printf,iout,'  rdshettle: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor
   endif

   printf,iout,'  '
   printf,iout,'  rdshettle: nlines ',nlines
   printf,iout,'  rdshettle: i,wcm,wavelength,rn,ri,'
   for i=0,nlines-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rn(i),ri(i)
   endfor


  endif

; ******
  return
  end


