   pro wrindices_orig,nopr,iout,outdir,$
   nwave,wcm,wavelength,rndat,ridat,iwave,$
   lset

; *************************
  filnm=strarr(1)
  filnm=strcompress(outdir+'indices_orig.ascii')

   idat=30
  openw,idat,filnm

; Will write out both wavenumbers and wavelength
; Have wavecm name consistent with indices_interp.ascii file
   wavecm=fltarr(nwave)

; Write out to the output ascii file
    printf,idat,'  '
    printf,idat,'  wrindices_orig: lset ',lset
    printf,idat,'  wrindices_orig: i,wavecm,wavelength,rndat,ridat'
   for i=0,nwave-1 do begin
     wavecm(i)=wcm(i)
    printf,idat,format='(1(1x,i4,","),2(1x,f10.4,","),2(1x,e10.3,","))',$
     i,wavecm(i),wavelength(i),rndat(i),ridat(i)
   endfor

   print,'  wrindices_orig: wrote to ',filnm
   close,idat

; *************************
; Write out to the output netCDF file
  wrfile=strarr(1)
  wrfile=strcompress(outdir+'indices_orig.nc')

; **
   ntext=2
   n40=40
  text=strarr(ntext)

  text0=strarr(1)
;       '1234567890123456789012345678901234567890'
  text0='                                        '
  strput,text0,lset,0
  text(0)=text0

;         '1234567890123456789012345678901234567890'
  text(1)=' The real and imaginary indices         '

; **
; Open the netCDF file
; The file is in define mode
     id=NCDF_CREATE(wrfile,/CLOBBER)

; **
; Define variable ids
     idnwave=NCDF_DIMDEF(id,'nwave',nwave)
     idntext=NCDF_DIMDEF(id,'ntext',ntext)

; For character strings
     idn40=NCDF_DIMDEF(id,'n40',n40)

; **
; Define variables
     id1=NCDF_VARDEF(id,'nwave',/SHORT)
     id2=NCDF_VARDEF(id,'ntext',/SHORT)
     id3=NCDF_VARDEF(id,'n40',/SHORT)

      dimx=[idnwave]
     id9=NCDF_VARDEF(id,'wavecm',dimx)
     id10=NCDF_VARDEF(id,'wavelength',dimx)
     id11=NCDF_VARDEF(id,'rndat',dimx)
     id12=NCDF_VARDEF(id,'ridat',dimx)

; **
; The text associated with the file
     id20=NCDF_VARDEF(id,'text',[idn40,idntext],/CHAR)

; **
; Put the file in data mode (so you can write to it)
     NCDF_CONTROL,id,/ENDEF

; **
; Specify the values
     NCDF_VARPUT,id,id1,nwave
     NCDF_VARPUT,id,id2,ntext
     NCDF_VARPUT,id,id3,n40

      countx=[nwave]
     NCDF_VARPUT,id,id9,wavecm,COUNT=countx
     NCDF_VARPUT,id,id10,wavelength,COUNT=countx
     NCDF_VARPUT,id,id11,rndat,COUNT=countx
     NCDF_VARPUT,id,id12,ridat,COUNT=countx

; Write out the character strings
     counts=[n40,ntext]
     NCDF_VARPUT,id,id20,text,COUNT=counts

; **
; Close the data set
     NCDF_CLOSE,id

; **
    print,'  wrindices_orig: wrote to ',wrfile

    printf,iout,'  '
    printf,iout,'  wrindices_orig: wrote to netCDF file '
    printf,iout,'  ',wrfile

; *************************
  return
  end
