  subroutine rdshettle(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ******
! Read in the data from the ascii file

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer :: noprf,mset
  integer,parameter :: ndat=500
  real :: wcmdat(ndat),wavedat(ndat),rnval(ndat),rival(ndat)
  character(len=60) :: fil
  character (len=16) :: files(18),llset

  integer :: ncomp,i,j
  integer :: nlines1,nlines2,nlines3,nlines4,nlines5
  real :: wcmdat1(ndat),wavedat1(ndat),rn1(ndat,4),ri1(ndat,4)
  real :: wcmdat2(ndat),wavedat2(ndat),rn2(ndat,4),ri2(ndat,4)
  real :: wcmdat3(ndat),wavedat3(ndat),rn3(ndat,4),ri3(ndat,4)
  real :: wcmdat4(ndat),wavedat4(ndat),rn4(ndat,4),ri4(ndat,4)
  real :: wcmdat5(ndat),wavedat5(ndat),rn5(ndat,4),ri5(ndat,4)

! ***
  nlines1 = 90
  nlines2 = 61
  nlines3 = 62
  nlines4 = 68
  nlines5 = 68
  ncomp = 18

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='/single_files/afcrl1987_shettle.dat                         '

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! ***
! Read in all of the data from the ascii file

! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

! Read in the data
   do i=1,201
    read(idat,fmt=100) header
   end do
   100 format(a80)

! *******
!                                  Table A2
!____________________________________________________________________________
!  WAVELENGTH WATER             ICE              SODIUM CHLORIDE  SEA SALT
!  microns    n     k           n     k          n      k         n      k
!_____________________________________________________________________________

!    0.200   1.396  1.10e-7    1.394  1.50e-8    1.790  3.1e-9    1.510  1.0e-4
!    0.250   1.362  3.35e-8    1.351  8.60e-9    1.655  2.3e-9    1.510  5.0e-6
!    0.300   1.349  1.60e-8    1.334  5.50e-9    1.607  1.5e-9    1.510  2.0e-6

! ****
! since data varies from sci notation and fixed point, use *
   do i=1,nlines1
    read(idat,*) wavedat1(i),rn1(i,1),ri1(i,1),rn1(i,2),ri1(i,2),&
     rn1(i,3),ri1(i,3),rn1(i,4),rn1(i,4)
    wcmdat1(i)=1.0e4/wavedat1(i)
   end do

   do i=1,11
    read(idat,fmt=100) header
   end do

! ****
   do i=1,nlines2
    read(idat,*) wavedat2(i),rn2(i,1),ri2(i,1),rn2(i,2),ri2(i,2),&
     rn2(i,3),ri2(i,3)
    wcmdat2(i)=1.0e4/wavedat2(i)
   end do

   do i=1,9
    read(idat,fmt=100) header
   end do

! ****
   do i=1,nlines3
    read(idat,*) wavedat3(i),rn3(i,1),ri3(i,1),rn3(i,2),ri3(i,2),&
     rn3(i,3),ri3(i,3),rn3(i,4),ri3(i,4)
    wcmdat3(i)=1.0e4/wavedat3(i)
   end do

   do i=1,10
    read(idat,fmt=100) header
   end do

! ****
   do i=1,nlines4
    read(idat,*) wavedat4(i),rn4(i,1),ri4(i,1),rn4(i,2),ri4(i,2),&
     rn4(i,3),ri4(i,3),rn4(i,4),ri4(i,4)
    wcmdat4(i)=1.0e4/wavedat4(i)
   end do

   do i=1,10
    read(idat,fmt=100) header
   end do

! ****
   do i=1,nlines5
    read(idat,*) wavedat5(i),rn5(i,1),ri5(i,1),rn5(i,2),ri5(i,2),&
     rn5(i,3),ri5(i,3)
    wcmdat5(i)=1.0e4/wavedat5(i)
   end do

! ****
! Close the input ascii file
   close (idat)

! ***
  if (nopr .eq. 1) then
   write(iout,fmt=110) nlines1,nlines2,nlines3,nlines4,nlines5
   110 format(/,2x,"rdshettle:  nlines1,nlines2,nlines3,nlines4,nlines5 ",/,&
   2x,5(1x,i4))
   write(iout,fmt=120) ncomp
   120 format(/,2x,"rdshettle:  ncomp",/,&
   2x,1(1x,i4))
  end if

! ***
! Obtain the listing of the compounds
! Will ask the user to choose which compound to work with

! Specify by hand (have code read in values)
!          '1234567890123456'
  files(1)='Water           '
  files(2)='Ice             '
  files(3)='NaCl            ' 
  files(4)='Seasalt         '
  files(5)='Water_soluble   '
  files(6)='Ammonium        '
  files(7)='Carbonaceous    '
  files(8)='Volcanic_dust   '
  files(9)='H2SO4 215K      '
  files(10)='H2SO4 300K     '
  files(11)='Meteor dust    '
  files(12)='Quartz oray    '
  files(13)='Quartz eray    '
  files(14)='Hematite oray  '
  files(15)='Hematite eray  '
  files(16)='Sand oray      '
  files(17)='Sand eray      '
  files(18)='Dust like      '

! *
! Write out the compounds included in the ascii file
  write(iout,fmt=130) ncomp
  130 format(/,2x,"rdshettle: ncomp ",i3)

  write(0,fmt=140)
  140 format(2x," Will select mset value for a specific compound")
  write(0,fmt=145)
  145 format(2x," i, compound")

  do i=1,ncomp
   j=i-1
   write(0,fmt=150) j,files(i)
   150 format(2x,i3,2x,a16)
  end do

  write(0,fmt=160)
  160 format(2x,"Specify mset (0-17) e.g. mset=7 for volcanic dust ")

  read(5,*) mset
  mset=int(mset)

! The compound string
  llset=files(mset+1)

  write(0,fmt=170) mset,llset
  170 format(2x," mset,llset ",i4,2x,a16)

! ***
! Obtain the specific indices

  if ((mset .ge. 0) .and. (mset .le. 3)) then 
     nlines=nlines1
    do i=1,nlines
     wcmdat(i)=wcmdat1(i)
     wavedat(i)=wavedat1(i)
    end do
     j=mset+1
    do i=1,nlines
     rnval(i)=rn1(i,j)
     rival(i)=ri1(i,j)
    end do
  end if

  if ((mset .ge. 4) .and. (mset .le. 6)) then
    nlines=nlines2
   do i=1,nlines
    wcmdat(i)=wcmdat2(i)
    wavedat(i)=wavedat2(i)
   end do
    j=mset-4+1
   do i=1,nlines
    rnval(i)=rn2(i,j)
    rival(i)=ri2(i,j)
   end do
  end if

  if ((mset .ge. 7) .and. (mset .le. 10)) then 
    nlines=nlines3
   do i=1,nlines
    wcmdat(i)=wcmdat3(i)
    wavedat(i)=wavedat3(i)
   end do
    j=mset-7+1
   do i=1,nlines
    rnval(i)=rn3(i,j)
    rival(i)=ri3(i,j)
   end do
  end if

  if ((mset .ge. 11) .and. (mset .le. 14)) then
    nlines=nlines4
   do i=1,nlines
    wcmdat(i)=wcmdat4(i)
    wavedat(i)=wavedat4(i)
   end do
    j=mset-11+1
   do i=1,nlines
    rnval(i)=rn4(i,j)
    rival(i)=ri4(i,j)
   end do
  end if

  if ((mset .ge. 15) .and. (mset .le. 17)) then 
    nlines=nlines5
   do i=1,nlines
    wcmdat(i)=wcmdat5(i)
    wavedat(i)=wavedat5(i)
   end do
    j=mset-15+1
   do i=1,nlines
    rnval(i)=rn5(i,j)
    rival(i)=ri5(i,j)
   end do
  end if

! *****
! Put values into the output arrays
! Since some of the data is 0 for real, redefine nlines
   mlines=0
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i)
   ridat(i)=rival(i)
   if (rndat(i) .gt. 0.0) then 
    mlines=mlines+1
   end if
  end do
  nlines=mlines

! *****
  if (nopr .eq. 1) then

    write(iout,fmt=800) mset,files(mset)
    800 format(/,2x,"rdshettle: work with mset, files(mset)",/,&
    2x,i3,2x,a16,/,&
    2x,"rdshettle: i,files(i)")
   do i=1,ncomp 
    write(iout,810) i,files(i)
    810 format(2x,i3,2x,a70)
   end do

    write(iout,fmt=840)
    840 format(/,2x,"rdshettle: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines 
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f10.4),1p,2(1x,e10.3))
   end do

  end if

! ******
  return
  end


