  subroutine rdstagg_carbon(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ******
! Read in the data from the ascii file

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=10,ncomp=4,mtempmax=4
  integer :: noprf,mset,itemp,i1,i2
  integer :: ntk
  integer :: ntemps(ncomp)
  real :: wcmdat(ndat,ncomp),wavedat(ndat,ncomp)
  real :: rnval(ndat,ncomp,mtempmax),rival(ndat,ncomp,mtempmax)
  real :: temps(ncomp,mtempmax)
  character(len=60) :: fil
  character (len=16) :: files(ncomp),llset

  data ntemps/4,4,3,3/

! files(1)='Pyro            '
  temps(1,1)=25.0
  temps(1,2)=200.0
  temps(1,3)=400.0
  temps(1,4)=600.0

! files(2)='Amorphous       '
  temps(2,1)=25.0
  temps(2,2)=200.0
  temps(2,3)=400.0
  temps(2,4)=600.0

! files(4)='Soot            '
  temps(3,1)=25.0
  temps(3,2)=300.0
  temps(3,3)=600.0

! files(4)='Soot            '
  temps(4,1)=25.0
  temps(4,2)=300.0
  temps(4,3)=600.0

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
!     '12345678901234567890123456789012345678901234567899'
  fil='single_files/stagg_carbon.dat                     '

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! Data: Real and imaginary indices of refraction of pyrolytic graphite,
! amorphous carbon, propane and flame soot 400 to 700 nm

! Reference: B. J. Stagg and T. T. Charalampopoulis, Refraction Indices
! of Pyrolytic Graphite, Amorphous Carbon, and Flame Soot in the
! Temperature Range 25 to 600C, Combustion and Flame, 94:381-396, 1993

! Contact: Steven Massie (Steven.Massie@lasp.colorado.edu)

! Format: 10 lines 2x,2(1x,f8.2),4(1x,f10.4)
!         10 lines 2x,2(1x,f8.2),4(1x,f10.4)

! pyro
!      cm-1    microns                     real
!                          25C        200C       400C       600C
!   25000.00     0.40     2.3770     2.4040     2.4160     2.4230
!   23094.69     0.43     2.5290     2.5440     2.5620     2.5550
!   21413.28     0.47     2.6370     2.6560     2.6750     2.6730
!   20000.00     0.50     2.6410     2.6580     2.6810     2.6810
!   18761.72     0.53     2.6480     2.6740     2.6910     2.6870
!   17636.68     0.57     2.6490     2.6750     2.6950     2.6950
!   16666.67     0.60     2.6560     2.6740     2.6950     2.6910
!   15797.79     0.63     2.6840     2.6990     2.7100     2.7100
!   14992.50     0.67     2.7170     2.7410     2.7310     2.7330
!   14285.71     0.70     2.7670     2.7880     2.7610     2.7760
!      cm-1    microns                     imaginary
!                          25C        200C       400C       600C
!   25000.00     0.40     1.6560     1.6520     1.6540     1.6510
!   23094.69     0.43     1.5280     1.5080     1.5150     1.5250
!   21413.28     0.47     1.4220     1.4290     1.4070     1.4070

! Read in all of the data

! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,12
   read(idat,fmt=100) header
  end do
  100 format(a80)

  nlines=10

  do j=1,4 
   ntk=ntemps(j)

  do i=1,4
   read(idat,fmt=100) header
  end do
  do i=1,nlines
   read(idat,*) wcmdat(i,j),wavedat(i,j),(rnval(i,j,k),k=1,ntk)
  end do
  do i=1,2
   read(idat,fmt=100) header
  end do
  do i=1,nlines
   read(idat,*) wdat1,wdat2,(rival(i,j,k),k=1,ntk)
  end do

  end do

  close (idat)

! ***
! Obtain the listing of the compounds
! Will ask the user to choose which compound to work with

! The different compositions
!          '1234567890123456'
  files(1)='Pyro            '
  files(2)='Amorphous       '
  files(3)='Propane         '
  files(4)='Soot            '

! *
! Write out the compounds included in the ascii file
  write(0,fmt=140)
  140 format(2x," Will select mset value for a specific compound")
  write(0,fmt=145)
  145 format(2x," i, compound")

  do i=1,ncomp
   write(0,fmt=150) i,files(i)
   150 format(2x,i3,2x,a16)
  end do

  write(0,fmt=160)
  160 format(2x,"Specify mset (1-4) e.g. mset=4 for Soot ")

  read(5,*) mset
  mset=int(mset)

! The compound string
  llset=files(mset)

  write(0,fmt=170) mset,llset
  170 format(2x," mset,llset ",i4,2x,a16)

! ***
! Obtain the specific indices
   nlines=10
   ntk=ntemps(mset)

   write(0,fmt=200)
   200 format(/,2x,"The temperatures to choose from")
  do i=1,ntk 
   i2=int(temps(mset,i))
   write(0,fmt=210) i2
   210 format(2x,i4)
  end do
   write(0,fmt=220)
   220 format(/,2x,"Specify the temperature in C (e.g. 300 )")
   read(5,*) temp

   itemp=-99
  if (temp .lt. temps(mset,1)) then
   itemp=1
   go to 230 
  end if
  if (temp .ge. temps(mset,ntk)) then
   itemp=ntk
   go to 230 
  end if
  do i=1,ntk-1 
    i2=i+1
   if ((temp .ge. temps(mset,i)) .and. (temp .lt. temps(mset,i2))) then
    itemp=i
    go to 230 
   end if
  end do
  230 mn=0

  if (itemp .le. 0) then
   write(iout,fmt=235) itemp
   235 format(/,2x," itemp ",i4," will stop")
   stop
  end if

  write(iout,fmt=240) itemp,temp,temps(mset,itemp)
  240 format(2x,"itemp,temp,temps(mset,itemp)",/,2x,i4,2(1x,f10.4))

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i,mset)
   wavelength(i)=wavedat(i,mset)
   rndat(i)=rnval(i,mset,itemp)
   ridat(i)=rival(i,mset,itemp)
  end do

! *****
  if (nopr .eq. 1) then
    write(iout,fmt=800) mset,files(mset)
    800 format(/,2x,"rdstagg_carbon: work with mset, files(mset)",/,&
    2x,i3,2x,a16)
    write(iout,fmt=840)
    840 format(2x,"rdstagg_carbon: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines 
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f10.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end


