  subroutine rddibiagio_desert(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! *****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
! Notice that the exact number of elements in rnval,rival works
! ndat  is the number of wavelengths
! ncomp is the number of compounts
  integer,parameter :: ndat=601,ncomp=19
  integer :: i,j1,j2,mn
  real :: diff,diffmin
! Note that the ndat,ncomp is opposite to the ncdump dump
  real :: wcmdat(ndat),wavedat(ndat)
  real :: rnval(ndat,ncomp),rival(ndat,ncomp)
  character(len=60) :: fil
  character (len=16) :: llset

  character(len=20) :: setsstr(ncomp)
!            '12345678901234567890'
  setsstr(1)='        Algeria     '
! setsstr(1)='Algeria             '
  setsstr(2)='Arizona             '
  setsstr(3)='Atacama             '
  setsstr(4)='Australia           '
  setsstr(5)='Bodele              '
  setsstr(6)='Ethiopia            '
  setsstr(7)='Gobi                '
  setsstr(8)='Kuwait              '
  setsstr(9)='Libya               '
!             '12345678901234567890'
  setsstr(10)='Mali                '
  setsstr(11)='Mauritania          '
  setsstr(12)='Morocco             '
  setsstr(13)='Namib-1             '
  setsstr(14)='Namib-2             '
  setsstr(15)='Niger               '
  setsstr(16)='Patagonia           '
  setsstr(17)='SaudiArabia         '
  setsstr(18)='Taklimakan          '
  setsstr(19)='Tunisia             '

! ***
! Read in the data from the ascii file
   lset=lstrn

! ***
! The input ascii file
!     '123456789012345678901234567890123456789012345678901234567890'
  fil='single_files/dibiagio_desert.dat                           '

! Obtain the full pathname of the input ascii file
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then
!  stop
  end if

! ***

!  Data: Real and imaginary indices of desert material
!  from 3.0 to 15.0 microns for 18 locations

!  Algeria
!  Arizona
!  Atacama
!  Australia
!  Bodele
!  Ethiopia
!  Gobi
!  Kuwait
!  Libya
!  Mali
!  Mauritania
!  Morocco
!  Namib-1
!  Namib-2
!  Niger
!  Patagonia
!  SaudiArabia
!  Taklimakan
!  Tunisia


!  Reference: Di Biagio C, Formenti P, Balkanski Y, Caponi L
!  Cazaunau, M., Pangui, E., Journet E, Nowak S, Caquineau S
!  Andreae M, Kandler K
!  Global scale variability of the mineral dust long-wave refractive
!  index: a new dataset of in situ measurements or climate modeling
!  and remotte sensing
!  Atm Chem Phys 2017;17(3):1901

!  Email contact person: C. Di Bagio (claudia.dibiagio@lisa.ipsl.fr)

!  Format: 601 real indices (2x,f8.2,2x,f10.4,10(2x,f5.3))
!          601 real indices (2x,f8.2,2x,f10.4,9(2x,f5.3))
!          601 imaginary indices (2x,f8.2,2x,f10.4,10(1x,e10.3))
!          601 imaginary indices (2x,f8.2,2x,f10.4,9(1x,e10.3))

!    cm-1       microns        real indices
!                        Alg    Ariz   Ata    Aust   Bod    Eth    Gob    Kuw    Lib    Mal
!   3333.33      3.0000  1.458  1.476  1.470  1.490  1.459  1.488  1.498  1.470  1.445  1.425
!   3311.26      3.0200  1.450  1.460  1.473  1.486  1.451  1.487  1.465  1.455  1.456  1.430

! ***
! Output ascii file f.out
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,42
   read(idat,fmt=100) header
  end do
  100 format(a80)

  nlines=ndat

   ncomp1=10
   ncomp2=9

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),(rnval(i,j),j=1,ncomp1)
   end do

  do i=1,3
   read(idat,fmt=100) header
  end do

   j1=11
   j2=19
   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),(rnval(i,j),j=j1,j2)
   end do

  do i=1,3
   read(idat,fmt=100) header
  end do

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),(rival(i,j),j=1,ncomp1)
   end do

  do i=1,3
   read(idat,fmt=100) header
  end do

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),(rival(i,j),j=j1,j2)
   end do

  close (idat)

! ****
! Will select the labooratory condition to work with
  do i=1,ncomp
   write(0,fmt=104) i,setsstr(i)
  end do
  104 format(2x,i2,2x,a20)

  write(0,fmt=140)
  140 format(2x,"Specify iset 1 to 8")
  read(5,*) iset

  write(0,fmt=165) iset
  165 format(2x," will use iset ",i2)

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i,iset)
   ridat(i)=rival(i,iset)
  end do

! *****
  if (nopr .eq. 1) then
    write(0,fmt=835) iset,setsstr(iset)
    write(iout,fmt=835) iset,setsstr(iset)
    835 format(/,2x,i2,2x,a20)
    write(iout,fmt=840) 
    840 format(/,2x,"rddibiagio_desert: i,wcm,wavelength,rndat,ridat")
   do i=1,nlines
    write(iout,fmt=850) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    850 format(2x,i4,2(1x,f12.4),1p,2(1x,e10.3))
   end do
  end if

! ******
  return
  end
