  subroutine rdhashemi_vanillic(nopr,iout,indir,outdir,lstrn,iset,&
  lset,llset,nlines,wcm,wavelength,rndat,ridat,iwave)

! ****
! param1.inc gives the maximum size of indices and extinction vectors
  include 'param1.inc'

! ****
! See rdinoutdir.f90
  character(len=60) :: indir,outdir
  integer :: nopr,iout,iset

! See main.f90
  integer :: nlines,iwave
  real :: wcm(nwavemax),wavelength(nwavemax)
  real :: rndat(nwavemax),ridat(nwavemax)
  character(len=100) :: lstrn,lset
  character(len=110) :: filnm

! Used here
  integer,parameter :: ndat=65
  integer :: noprf
  real :: wcmdat(ndat),wavedat(ndat),rnval(ndat),rival(ndat)
  character(len=60) :: fil
  character(len=16) :: llset

! ***
! Read in the data from the ascii file
   lset=lstrn

!       '1234567890123456'
  llset='Hashemi vanillic'

! ***
! The input ascii file
!     '123456789012345678901234567890'123456789012345678901234567890'
  fil='single_files/hashemi_vanillic_acid.dat                       '
   noprf=1
  call getfilnm(noprf,iout,fil,indir,filnm)
  if (noprf .eq. 1) then  
!  stop
  end if

! *****

!  Data: Real and imaginary indices of vanillic acid aerosol
!  from 0.27 to 0.6 microns

!  Reference: Hashemi V, Galpin T Greenslade M
!  Complex refractive index of vanillic acid aerosol retrieved from
!  from 270-600 nm using aerosol extinction and solution phase
!  absorption measurements
!  Aer Sci Tech, 2024;58(5):569

!  Email contact: M. Greenslade (margaret.e.greenslade@gmail.com)

!  Format: 65 real indices (2x,f8.2,2x,f10.4,1(2x,f5.3))
!          65 imaginary indices (2x,f8.2,2x,f10.4,1(1x,e10.3))

!    cm-1       microns   real indices
!                        vanillic acid
!  37037.04      0.2700  1.620
!  36363.64      0.2750  1.650

! *****
! Read in the data

! Input ascii file
   idat=35
  open(idat,form='formatted',file=filnm,status='unknown')

  do i=1,17
   read(idat,fmt=100) header
  end do
  100 format(a80)

   nlines=ndat

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),rnval(i)
   end do

  do i=1,3
   read(idat,fmt=100) header
  end do

   do i=1,nlines
    read(idat,*) wcmdat(i),wavedat(i),rival(i)
   end do

  close (idat)

! *****
! Put values into the output arrays
  do i=1,nlines
   wcm(i)=wcmdat(i)
   wavelength(i)=wavedat(i)
   rndat(i)=rnval(i)
   ridat(i)=rival(i)
  end do

! *****
  if (nopr .eq. 1) then

   write(iout,fmt=200) nlines,fil
   200 format(/,2x,"rdhashemi_vanillic: nlines,fil",/,&
   2x,i4,2x,a60)
   write(iout,fmt=230)
   230 format(2x,"rdhashemi_vanillic.f90d: i,wcm,wavelength,rndat and ridat")
   do i=1,nlines
    write(iout,fmt=240) i,wcm(i),wavelength(i),rndat(i),ridat(i)
    240 format(2x,i4,1p,2(1x,e10.3),2x,2(1x,e10.3))
   end do

  end if

! ******
  return
  end
