   pro comparemix,nopr,iout,$
   imix,imix1,imix2,$
   nsets,listrn,lstrn,$
   indir,outdir,iwave,w1,w2

   jset=intarr(2)
   jset(0)=imix1
   jset(1)=imix2

; *************************
; iwave=1 for wavenumber scales and iwave=2 for wavelength scales

; *************************
; Loop over the two sets
    mset=-1
   for ncalc=0,1 do begin
    iset=jset(ncalc)
    mset=mset+1

; *************************
; The set to work with
   lstrn=strarr(1)
   lstrn=strcompress(listrn(iset))

; *************************
    noprc=1
  if (noprc eq 1) then begin
   printf,iout,'  '
   printf,iout,'  comparemix: iset '
   printf,iout,'  ',iset
   printf,iout,'  comparemix: lstrn
   printf,iout,'  ',lstrn
   nopr=0
  endif

; *************************
; The iset and numbers here must be corrdinated with the   indices.dat   files

; **
; Read in the Tisdale h2so4 indices
  if (iset eq 0) then begin
   tisdale,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
  endif

; **
; Read in one Eric Shettle set of indices
  if (iset eq 1) then begin
   shettle,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
  endif

; **
; Read in the Grainger volcanic ash indices
  if (iset eq 2) then begin
   lset=lstrn
   grainger,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
  endif

; **
; Store for output

; First set
    if (mset eq 0) then begin
       nwave1=nlines
      wave1=fltarr(nwave1)
      rn1=fltarr(nwave1)
      ri1=fltarr(nwave1)
     for i=0,nlines-1 do begin
      if (iwave eq 1) then begin
       wave1(i)=wcm(i)
      endif
      if (iwave eq 2) then begin
       wave1(i)=wavelength(i)
      endif
      rn1(i)=rndat(i)
      ri1(i)=ridat(i)
     endfor
     lset1=lset
    endif

; 2nd set
    if (mset eq 1) then begin
       nwave2=nlines
      wave2=fltarr(nwave2)
      rn2=fltarr(nwave2)
      ri2=fltarr(nwave2)
     for i=0,nlines-1 do begin
      if (iwave eq 1) then begin
       wave2(i)=wcm(i)
      endif
      if (iwave eq 2) then begin
       wave2(i)=wavelength(i)
      endif
      rn2(i)=rndat(i)
      ri2(i)=ridat(i)
     endfor
     lset2=lset
    endif

  endfor

; *************************
; Obtain the refractive indices for a mixture

; You are asked to specify the volume fraction of the 
; inclusions (f2)
   print,' Specify the volume fraction of the inclusions (e.g. f2=0.02)
   read,f2

   print,'  '
   print,'  comparemix: volume fraction of inclusions is ',f2

; *****
; For case when the nwave1 and nwave2 values are not the same
   if (nwave1 ne nwave2) then begin
    stop
   endif

; *****
; For case when the nwave1 and nwave2 values are the same
   if (nwave1 eq nwave2) then begin

     iwrsp=0
    if (iwrsp eq 1) then begin
     printf,iout,'  comparemix: simple, debye, maxwell-garnett, bruggeman'
     printf,iout,'  i,wavemix(i),rn values, ri values'
    endif

      nwave=nwave1
      ncase=4
     wavemix=fltarr(nwave1)
     rnmix=fltarr(nwave1,ncase)
     rimix=fltarr(nwave1,ncase)
     vecn=fltarr(ncase)
     veci=fltarr(ncase)
    for i=0,nwave-1 do begin

; **
; The output wavelength 
    wavemix(i)=wave1(i)

; **
; matrix (1st set of indices)
      a1=rn1(i)
      b1=ri1(i)
     m1=complex(a1,b1)

; **
; inclusions (2nd set of indices)
      a2=rn2(i)
      b2=ri2(i)
     m2=complex(a2,b2)

; **
; Simple volume or mass mixing
     simplemix,iout,m1,m2,f2,m3
     rnmix(i,0)=float(m3)
     rimix(i,0)=imaginary(m3)

; The debye mixing rule
     debye,iout,m1,m2,f2,m3
     rnmix(i,1)=float(m3)
     rimix(i,1)=imaginary(m3)

; The maxwwell-garnett mixing rule
     maxwell,iout,m1,m2,f2,m3
     rnmix(i,2)=float(m3)
     rimix(i,2)=imaginary(m3)

; The bruggeman mixing rule
     bruggeman,iout,m1,m2,f2,m3
     rnmix(i,3)=float(m3)
     rimix(i,3)=imaginary(m3)
    
    if (iwrsp eq 1) then begin
     for j=0,ncase-1 do begin
      vecn(j)=rnmix(i,j)
      veci(j)=rimix(i,j)
     endfor
     printf,iout,format='(1(1x,i3),1(1x,f10.4),2x,4(1x,f10.4),2x,4(1x,f10.4))',$
     i,wavemix(i),vecn,veci
    endif
    
    endfor

; For graphs
    w1=min(wavemix)
    w2=30.0

   endif
; For nwave1=nwave2

   if (iwrsp eq 1) then begin
    stop
   endif

; *************************
; Determine how many points to work with

       nuse1=0
      for i=0,nwave1-1 do begin
       if ((wave1(i) ge w1) and (wave1(i) le w2)) then begin
        nuse1=nuse1+1
       endif
      endfor

       nuse2=0
      for i=0,nwave2-1 do begin
       if ((wave2(i) ge w1) and (wave2(i) le w2)) then begin
        nuse2=nuse2+1
       endif
      endfor

; *************************
; Graph the results

; The output ps graphics file
    fileps=strcompress(outdir+'gcomparemix.ps')

; Open the output ps file
    set_plot, 'ps'
    device, /color, bits_per_pixel=8, file=fileps,$
     /portrait,/inch,ysize=9.0,xsize=7.0,xoffset=0.6,yoffset=1.0

; *****
; have graphs plus the color bar
; [ignore,horizontal,vertical]
   !P.MULTI=[0,1,2]

; Load the color table
   loadct,26

; Bold fonts
   !P.font=0

; ****
; Will put graph on the same page
      ngraphs=2
     titles=strarr(ngraphs)
     titles=['Real Index ','Imaginary Index']

     printf,iout,'  '
     printf,iout,'  comparemix: nwave1,nwave2'
     printf,iout,'  ',nwave1,nwave2
     printf,iout,'  comparemix: nuse1,nuse2'
     printf,iout,'  ',nuse1,nuse2

; Loop over the graphs
     jsym=intarr(ncase)
     clr=fltarr(ncase)
     jsym=[1,4,5,6]
     clr=[30.0,60.0,120.0,210.0]
    for ii=0,ngraphs-1 do begin

; Specify the points
      xvec=fltarr(nuse1,ncase)
      yvec=fltarr(nuse1,ncase)
      isym=intarr(nuse1,ncase)
      clri=fltarr(nuse1,ncase)

      vecj=fltarr(ncase)
      words=strarr(ncase)
      words=['Average ','Debye ','Maxwell-Garnett','Bruggeman']

      for jj=0,ncase-1 do begin
       j=-1
      for i=0,nuse1-1 do begin
       if ((wave1(i) ge w1) and (wave1(i) le w2)) then begin
         j=j+1
         xvec(j,jj)=wavemix(i)
        if (ii eq 0) then begin
         yvec(j,jj)=rnmix(i,jj)
        endif
        if (ii eq 1) then begin
         yvec(j,jj)=rimix(i,jj)
        endif
        isym(j,jj)=jsym(jj)
        clri(j,jj)=clr(jj)
        vecj(jj)=clr(jj)
       endif
      endfor
      endfor

     iwr=1
    if (iwr eq 1) then begin
      printf,iout,'  '
     for jj=0,ncase-1 do begin
      printf,iout,'  comparemix: jj ',jj
      printf,iout,'  comparemix: i,xvec(i,jj),yvec(i,jj),isym(i,jj),clri(i,jj)'
     for i=0,nuse1-1 do begin
      printf,iout,'  ',i,xvec(i,jj),yvec(i,jj),isym(i,jj),clri(i,jj)
     endfor
     endfor
    endif

    if (iwave eq 1) then begin
     labelx='Wavenumber (cm-1)'
    endif
    if (iwave eq 2) then begin
     labelx='Wavelength (microns)'
    endif

    labely=titles(ii)
;   title=strcompress(lset1+' '+lset2)
    title=' '

    xmin=min(xvec)
    xmax=max(xvec)
    ymin=min(yvec)
    ymax=max(yvec)
    iyreverse=0

    if (ii eq 0) then begin
     x0=0.55
     y0=0.60
    endif
    if (ii eq 1) then begin
     x0=0.75
     y0=0.60
    endif

     x0=0.50
     y0=0.85

    iwrlabel=1

    title0='  '
    title1='  '
    title2='  '
    titlej='  '

     nlines=ncase
     num1=nuse1
    graphlines,nopr,iout,ii,$
    nlines,num1,xvec,yvec,clri,isym,$
    labelx,labely,title0,title1,title2,$
    xmin,xmax,ymin,ymax,iyreverse,$
    titlej,words,vecj,x0,y0,iwrlabel

; *************************
; Write out to the f.out file
   iwrkld=1
  if (iwrkld eq 1) then begin
    vec4=fltarr(4)
    printf,iout,'  '
;     words=['Average ','Debye ','Maxwell-Garnett','Bruggeman']

    if (ii eq 0) then begin
     printf,iout,'  '
     printf,iout,'  real index'
    endif
    if (ii eq 1) then begin
     printf,iout,'  '
     printf,iout,'  imaginary index'
    endif
    printf,iout,'  i,wavel,ave,debye,maxwell_garnett,bruggeman,'  
   for i=0,nuse1-1 do begin
    for j=0,ncase-1 do begin
     vec4(j)=yvec(i,j)
    endfor
    printf,iout,format='(1(1x,i3,","),1(1x,f10.4,","),4(1x,f10.4,","))',$
     i,wavemix(i),vec4
   endfor
  endif

    endfor
; Loop over the graphs

; Close the output ps graphics file
    print,' wrote ',fileps
    device,/close

  stop

; *************************
  return
  end
