; Convert to log-normal parameters
   pro convertsizep,nopr,iout,lsetg,$
   denv,radv,sigv,den,rad,sig

; *****
; See Remer JGR v 103, p13859, 1998 article
; on how to convert dV/dlnr size parameters to dN/dlnr
; Since you work with alogs of sig1 and sig2, you
; take exps here.

   pi=3.14159265
   const=(4.0*pi)/3.0

   rg3=radv*radv*radv
   den=denv/(const*rg3*exp((9.0*sigv*sigv)/2.0))

   a1=-3.00*sigv*sigv
   rad=radv*exp(-a1)

   sig=exp(sigv)

; *****
  if (nopr eq 1) then begin
   printf,iout,'  '
   printf,iout,'  convertsizep: ',lsetg
   printf,iout,'  convertsizep: denv,radv,sigv '
   printf,iout,'  ',denv,radv,sigv
   printf,iout,'  convertsizep: den,rad,sig'
   printf,iout,'  ',den,rad,sig
  endif

; *****
  return
  end
