  pro multisetsgraph,nopr,iout,$
  dirmultisets,outdir

; The user first runs the program (with imultisetsgraph=0) for a given iset material
; several times (e.g. for iset=14 the Deguine indices for 6 vaolcanic ash cases can be
; calculated, one at a time)
; The user places    idl_calc/output/indices.ascii   files into the     multisets   subdirectory
; by the unix command  e.g. cp output/indices.ascii  multisets/Calbuco.dat
;    Calbuco.dat  Chaiten.dat  Etna.dat  Eyjafjall.dat  Grimsvotn.dat  Puyehue.dat  z.list
; The user then does the command    ls multisets/*.dat > multisets/z.list
; to create the z.list
; The z.list is read in by this routine.

; User: supply a title for the graph here
   titlegr='Deguine Volcanic'

; ****************************
; The ps file names for the real and imaginary indices
  filepsreal=strcompress(outdir+'multi_real.ps')
  filepsimag=strcompress(outdir+'multi_imag.ps')
  filepsboth=strcompress(outdir+'multi_both.ps')

  fsavereal=strcompress(outdir+'multi_real.sav')
  fsaveimag=strcompress(outdir+'multi_imag.sav')

  print,filepsreal
  print,filepsimag
  print,filepsboth
  print,fsavereal
  print,fsaveimag

; ****************************
; Read in the ascii file names of the indices.ascii files
  flist=strcompress(dirmultisets+'z.list')
   noprf=1
  readflist,nopr,iout,flist,nfiles,files2

; Obtain the curve labels
   curvelabels=strarr(nfiles)
  for i=0,nfiles-1 do begin
   ipos=strpos(files2(i),'.dat')
   nlen=strlen(files2(i))
    istart=0
    npos=nlen-4
    str1=strmid(files2(i),istart,npos)
   curvelabels(i)=str1
  endfor

; ****************************
; Obtain the full pathname
  files=strarr(nfiles)
   printf,iout,'  '
   printf,iout,'  multisetsgraph: i, files(i)'
  for i=0,nfiles-1 do begin
   files(i)=strcompress(dirmultisets+files2(i))
   printf,iout,'  ',i,' ',files(i)
  endfor

; ****************************
; Loop over the data files and read in the data
   for ii=0,nfiles-1 do begin

; ***
; wrindices: lset   Deguine volcanic ash idl
; wrindices: nlines
;      136
; wrindices: i,wavecm,wavelength,rn,ri
;   0, 25000.0000,     0.4000,  1.609e+00,  4.802e-04,
;   1, 20000.0000,     0.5000,  1.609e+00,  5.650e-04,
;   2, 16666.6660,     0.6000,  1.609e+00,  6.203e-04,

; ***
; The input ascii data file
  filnm=files(ii)

; ***
   idat=40
  openr,idat,filnm

   header=strarr(1)
  for i=1,2 do begin
   readf,idat,header
  endfor

  readf,idat,nwave
  readf,idat,header

  if (ii eq 0) then begin
   wavecm=fltarr(nwave,nfiles)
   wavelength=fltarr(nwave,nfiles)
   rn=fltarr(nwave,nfiles)
   ri=fltarr(nwave,nfiles)
  endif

  for i=0,nwave-1 do begin
   readf,idat,jj,wcm,wlen,rnval,rival
   wavecm(i,ii)=wcm
   wavelength(i,ii)=wlen
   rn(i,ii)=rnval
   ri(i,ii)=rival
  endfor

; Close the input file
   close,idat

   endfor
; Loop over files

; ****************************
  noprg=0

; Graph the imaginary indices on one page
   icase=1
  grmultisets,noprg,iout,filepsreal,icase,$
  nwave,nfiles,wavecm,wavelength,rn,ri,$
  curvelabels,titlegr,fsavereal

; ****************************
; Graph the imaginary indices on one page
   icase=2
  grmultisets,noprg,iout,filepsimag,icase,$
  nwave,nfiles,wavecm,wavelength,rn,ri,$
  curvelabels,titlegr,fsaveimag

; ****************************
; Graph the real and imaginary indices on the same page
  grmultboth,noprg,iout,filepsboth,icase,$
  nwave,nfiles,wavecm,wavelength,rn,ri,$
  curvelabels,titlegr,fsavereal,fsaveimag

  stop

; ****************************
  return
  end
