   pro rdbiermann_h2so4,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlinesr,wcmr,wavelengthr,rndat,$
   nlinesi,wcmi,wavelengthi,ridat,$
   ndifferent

; ***
; Note that the number of real and imaginary values are not the same
; so set ndifferent=1
   ndifferent=1

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file
  fil=strarr(1)
  fil='biermann_h2so4.nc'
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnumlinesr=ncdf_varid(nc_id,'numlinesr')
  idnumlinesi=ncdf_varid(nc_id,'numlinesi')
  idntemps=ncdf_varid(nc_id,'ntemps')
  idwh2so4=ncdf_varid(nc_id,'wh2so4')
  idnwh2so4=ncdf_varid(nc_id,'nwh2so4')
  idtemps=ncdf_varid(nc_id,'temps')
  idntemps=ncdf_varid(nc_id,'ntemps')
  idwcmr=ncdf_varid(nc_id,'wcmr')
  idwavelengthr=ncdf_varid(nc_id,'wavelengthr')
  idrn=ncdf_varid(nc_id,'rn')
  idwcmi=ncdf_varid(nc_id,'wcmi')
  idwavelengthi=ncdf_varid(nc_id,'wavelengthi')
  idri=ncdf_varid(nc_id,'ri')
  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idnumlinesr,numlinesr
  ncdf_varget,nc_id,idnumlinesi,numlinesi
  ncdf_varget,nc_id,idwh2so4,wh2so4
  ncdf_varget,nc_id,idnwh2so4,nwh2so4
  ncdf_varget,nc_id,idntemps,ntemps
  ncdf_varget,nc_id,idtemps,temps
  ncdf_varget,nc_id,idwcmr,wcmr2
  ncdf_varget,nc_id,idwavelengthr,wavelengthr2
  ncdf_varget,nc_id,idrn,rn
  ncdf_varget,nc_id,idwcmi,wcmi2
  ncdf_varget,nc_id,idwavelengthi,wavelengthi2
  ncdf_varget,nc_id,idri,ri

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; *****
  print,'  '
  print,'  biermann h2so4'
  print,'  ntemps ',ntemps
  print,'  nwh2so4 ',nwh2so4
  print,'  Note that 0% is an actual value (can specify)'
  print,'  The table to choose from'
  for i=0,ntemps-1 do begin

    jnum=0
   for j=0,11 do begin
     a1=wh2so4(i,j)
    if ((j ge 1) and (a1 lt 5.0)) then begin
     goto,jump1
    endif
    jnum=jnum+1
   endfor
   jump1:mn=0

    nval=jnum
    vec2=fltarr(nval)
    ivec2=intarr(nval)
   for j=0,nval-1 do begin
    vec2(j)=wh2so4(i,j)
    ivec2(j)=fix(wh2so4(i,j))
   endfor

   print,format='(1x,2x,1(1x,f10.4),2x,12(1x,i4))',$
    temps(i),ivec2

  endfor

; *****
   print,'  '
   print,'  specify temperature and h2so4 pair (e.g. 203.0, 57.0)
   print,'  specify temp'
   read,temp
   print,'  specify h2so4'
   read,h2so4

    diffmin=1.0e6
    ival=-99
    jval=-99
   for i=0,ntemps-1 do begin
   for j=0,nwh2so4-1 do begin
    diff1=temp-temps(i)
    diff2=h2so4-wh2so4(i,j)
    diff=sqrt((diff1*diff1)+(diff2*diff2))
    if (diff lt diffmin) then begin  
     ival=i
     jval=j
     diffmin=diff
    endif
   endfor
   endfor

   if ((ival lt 0) or (jval lt 0)) then begin
    print,'  '
    print,'  rdbiermann_h2so4: ival,jval ',ival,jval
    print,'  rdbiermann_h2so4: ival or jval lt 0, will stop'
    stop
   endif

; **
   tempstr=strarr(1)
   tempstr=string(fix(temps(ival)))
   h2so4str=strarr(1)
   h2so4str=string(fix(wh2so4(ival,jval)))

; **
    nlinesr=fix(numlinesr(ival))
    nlinesi=fix(numlinesi(ival))

    rndat=fltarr(nlinesr)
    ridat=fltarr(nlinesi)
    wcmr=fltarr(nlinesr)
    wcmi=fltarr(nlinesi)
    wavelengthr=fltarr(nlinesr)
    wavelengthi=fltarr(nlinesi)

    print,'  '
    print,'  rdbiermann_h2so4: nlinesr,nlinesi,temp,temps(ival) '
    print,'  ',nlinesr,nlinesi,temp,temps(ival)
    print,'  rdbiermann_h2so4: nlinesr,nlinesi,h2so4,wh2so4(ival,jval) '
    print,'  ',nlinesr,nlinesi,h2so4,wh2so4(ival,jval)

    printf,iout,'  '
    printf,iout,'  rdbiermann_h2so4: nlinesr,nlinesi,temp,temps(ival) '
    printf,iout,'  ',nlinesr,nlinesi,temp,temps(ival)
    printf,iout,'  rdbiermann_h2so4: nlinesr,nlinesi,h2so4,wh2so4(ival,jval) '
    printf,iout,'  ',nlinesr,nlinesi,h2so4,wh2so4(ival,jval)


; **
; Specify the output values
; wcmr and wcmi are the same 
   for i=0,nlinesr-1 do begin
    rndat(i)=rn(i,ival,jval)
    wcmr(i)=wcmr2(i,ival)
    wavelengthr(i)=wavelengthr2(i,ival)
   endfor
   for i=0,nlinesi-1 do begin
    ridat(i)=ri(i,ival,jval)
    wcmi(i)=wcmi2(i,ival)
    wavelengthi(i)=wavelengthi2(i,ival)
   endfor

; Graphs label
   lset=strcompress(lstrn+' '+tempstr+' K '+h2so4str+' %')

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdbiermann_h2so4: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdbiermann_h2so4: i,wcmr,wavelengthr,rndat'
   for i=0,nlinesr-1 do begin
    printf,iout,'  ',i,wcmr(i),wavelengthr(i),rndat(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdbiermann_h2so4: i,wcmi,wavelengthi,ridat'
   for i=0,nlinesi-1 do begin
    printf,iout,'  ',i,wcmi(i),wavelengthi(i),ridat(i)
   endfor

  endif

; ******
  return
  end
