   pro rdherbinquartz,nopr,iout,filnm,$
   ntext,text,$
   nlines,wcm,wavelength,rndat,ridat,rnerr,rierr

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file is filnm

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnfiles=ncdf_varid(nc_id,'nfiles')
  idnwave=ncdf_varid(nc_id,'nwave')

  idwcm=ncdf_varid(nc_id,'wcm')
  idwavelength=ncdf_varid(nc_id,'wavelength')
  idrn=ncdf_varid(nc_id,'rn')
  idri=ncdf_varid(nc_id,'ri')

  idtext=ncdf_varid(nc_id,'text')
  idquartzstrs=ncdf_varid(nc_id,'quartzstrs')

  idn70=ncdf_varid(nc_id,'n70')
  idn20=ncdf_varid(nc_id,'n20')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idn20,n20
  ncdf_varget,nc_id,idnfiles,nfiles
  ncdf_varget,nc_id,idnwave,nwave

  ncdf_varget,nc_id,idwcm,wcm
  ncdf_varget,nc_id,idwavelength,wavelength
  ncdf_varget,nc_id,idrn,rn
  ncdf_varget,nc_id,idri,ri

  text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; quartzstrs=strarr(n20)
; ncdf_varget,nc_id,idquartzstrs,quartzstrs
; quartzstrs=string(quartzstrs)

   quartzstrs=strarr(nfiles)
   quartzstrs=strarr(nfiles)
;           '1234567890123'
   quartzstrs=['quartz']

; ****
; Close the data set
  ncdf_close,nc_id

; ****
   ihelp=0
  if (ihelp eq 1) then begin
   help,rn
   help,ri
   help,wcm
   help,wavelength
   help,nwave
   help,ntext
   help,text
   help,quartzstrs
   stop
  endif

; *****
  print,'  '
  print,'  Herbin quartz'

; ***
   text2=string(quartzstrs)
;  lset=strcompress(lstrn+text2)

; *****
; Output values
   nlines=nwave

; Specify the indices
    jval=0
    rndat=fltarr(nwave)
    ridat=fltarr(nwave)
; have 0.0
    rnerr=fltarr(nwave)
    rierr=fltarr(nwave)
   for i=0,nwave-1 do begin
    rndat(i)=rn(i)
    ridat(i)=ri(i)
   endfor

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdherbinquartz: filnm ',filnm
    printf,iout,'  '
    printf,iout,'  rdherbinquartz: next ',ntext
    printf,iout,'  rdherbinquartz: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdherbinquartz: nwave ',nwave
   printf,iout,'  rdherbinquartz: quartzstrs ',quartzstrs
   printf,iout,'  rdherbinquartz: i,wcm,wavelength,rndat and ridat'
   for i=0,nwave-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end
