   pro rdindices,nopr,iout,$
   indir,$
   iset,igraphi,$
   nsets,listrn,lstrn,$
   nlines,wcm,wavelength,rndat,ridat,$
   outdir,iwave,iwrind,lset,ibothpos

; *************************
; Will set ibothpos=1 if you specify real and imaginary
; Some sets have only e.g. imaginary indices (Kou)
; For these cases, set ibothpos=0
   ibothpos=1

; If the number of real and imaginary indices are different, then
; ndifferent=1
   ndifferent=0

; *************************
; The set to work with
   lstrn=strarr(1)
   lstrn=strcompress(listrn(iset))

; *************************
  if (nopr eq 1) then begin
   printf,iout,'  '
   printf,iout,'  rdindices: iset '
   printf,iout,'  ',iset
   printf,iout,'  rdindices: lstrn
   printf,iout,'  ',lstrn
  endif

; *************************
; The iset and numbers here must be corrdinated with the   indices.dat   files
; e.g. Tisdale h2so4 indices are the first index set. Note that
; IDL is 0 based so that e.g. vec(0) is the first element in the vector vec.

  ifound=-1

; **
; Read in one of the  Eric Shettle set of indices
  if (iset eq 0) then begin
   shettle,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   ifound=1
   goto,jump1
  endif

; **
; Read in the Downing and Williams water indices
  if (iset eq 1) then begin
   rddowning,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   ifound=1
   goto,jump1
  endif

; **
; Read in Wagner supercooled water indices
  if (iset eq 2) then begin
   rdwagner_supercooled,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   ifound=1
   goto,jump1
  endif

; **
; Read in Warren ice indices
  if (iset eq 3) then begin
   rdwarren_ice,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   ifound=1
   goto,jump1
  endif

; **
; Read in Clapp ice indices
  if (iset eq 4) then begin
   rdclapp_ice,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   ifound=1
   goto,jump1
  endif

; **
; Read in the Tisdale h2so4 indices
  if (iset eq 5) then begin
   tisdale,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   ifound=1
   goto,jump1
  endif

; **
; Read in the Myhre h2so4 indices
  if (iset eq 6) then begin
   rdmyhre_h2so4,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   ifound=1
   goto,jump1
  endif

; **
; Read in the Myhre hno3 indices
  if (iset eq 7) then begin
   rdmyhre_hno3,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   ifound=1
   goto,jump1
  endif

; **
; Read in the myhre hno3/h2so4/h2o
  if (iset eq 8) then begin
   rdmyhre_ternary,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   ifound=1
   goto,jump1
  endif

; **
; Read in the Niedziela NAD indices
  if (iset eq 9) then begin
   rdniedziela_nad,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   ifound=1
   goto,jump1
  endif

; **
; Read in the Richwine nat indices
  if (iset eq 10) then begin
   rdrichwine_nat,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   ifound=1
   goto,jump1
  endif

; **
; Read in the Toon PSC indices
  if (iset eq 11) then begin
   rdtoon_psc,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   ifound=1
   goto,jump1
  endif

; **
; Read in the Wagner saharan dust
  if (iset eq 12) then begin
   rdwagner_sahara_dust,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the Di Biagio desert indices
  if (iset eq 13) then begin
   dibiagio,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   ifound=1
   goto,jump1
  endif

; **
; Read in the Grainger volcanic ash indices
  if (iset eq 14) then begin
   grainger,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   ifound=1
   goto,jump1
  endif

; **
; Read in Deguine volcanic ash
  if (iset eq 15) then begin
   rddeguine_ash,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in Reed volcanic ash indices
  if (iset eq 16) then begin
   reed,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in Liu SOA ACP 2015
  if (iset eq 17) then begin

   rdliu_soa_acp,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlinesr,wcmr,wavelengthr,rndat,$
   nlinesi,wcmi,wavelengthi,ridat,$
   ndifferent

; Since ndifferent eq 1, will put on common grid
   if (ndifferent eq 1) then begin
    samewave,nopr,iout,$
    nlines,wcm,wavelength,$
    nlinesr,wcmr,wavelengthr,rndat,$
    nlinesi,wcmi,wavelengthi,ridat
     goto,jump1
   endif
  endif

; **
; Read in Liu SOA est paper
  if (iset eq 18) then begin
   rdliu_soa_est,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; Read in He SOA indices
  if (iset eq 19) then begin
   rdhe_soa,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; Read in Famg SOA indices
  if (iset eq 20) then begin
   rdfang_soa,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; Read in Hashemi vanillic acid indices
  if (iset eq 21) then begin
   rdhashemi_van,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the Myhre organic acids
  if (iset eq 22) then begin
   rdmyhre_organic_acids,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the Alexander brown carbon indices
  if (iset eq 23) then begin
   rdalexander_brown_carbon,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the Sutherland and khanna burning vegetation indices
  if (iset eq 24) then begin
   rdsutherland,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   ifound=1
   goto,jump1
  endif

; **
; Read in the Shepherd Wood smoke and Humic
  if (iset eq 25) then begin
   rdshepherd_wood,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   ifound=1
   goto,jump1
  endif

; **
; Read in the Magi SAFARI field data for biomass fire
  if (iset eq 26) then begin
   rdmagi_biomass_fire,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the Stagg carbon flame indices
  if (iset eq 27) then begin
   rdstagg_carbon_flame,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the Chang flame soot indices
  if (iset eq 28) then begin
   rdchang_flame_soot,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the Querry minerals (1987 compilation)
  if (iset eq 29) then begin
   rdquerry_minerals,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the Toon mont granite
  if (iset eq 30) then begin
   rdtoon_mont_granite,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the chehab kaolinite
  if (iset eq 31) then begin
   rdchehab_kaolinite,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the chehab kaolinite
  if (iset eq 32) then begin
   rdherbin_quartz,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the Khare Titan tholins data
  if (iset eq 33) then begin
   rdkhare_tholins,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the Ramirez Titan Aerosol
  if (iset eq 34) then begin
   rdramirez_titan_aerosol,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in Imanaka Titan tholins
  if (iset eq 35) then begin
   rd_imanaka,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in Jovanovic Pluto aerosol analogue
  if (iset eq 36) then begin
   rdjovanovic_pluto,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the Querry KCl data
  if (iset eq 37) then begin
   rdquerry_kcl,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the Querry ZnS data
  if (iset eq 38) then begin
   rdquerry_zns,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the Henning and Mutschke SiO2 low temperature data
  if (iset eq 39) then begin
   rdhenning_sio2_lowtemp,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the Zeidler SiO2 high temperature data
  if (iset eq 40) then begin
   rdzeidler_sio2_hightemp,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the Begemann Al2O3, porous and compact
  if (iset eq 41) then begin
   rdbegemann_al2o3,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the Henning FeO data
  if (iset eq 42) then begin
   rdhenning_feo,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the Posch CaTio3 data
  if (iset eq 43) then begin
   rdposch_catio3,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the Triaud Fe2O3 data
  if (iset eq 44) then begin
   rdtriaud_fe2o3,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the Jena visible Fe2SiO4 
  if (iset eq 45) then begin
   rdjena_fe2sio4,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in Fabian mid and far ir Fe2SiO4
  if (iset eq 46) then begin
   rdfabian_fe2sio4,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in Fabian MgAl2O54 data
  if (iset eq 47) then begin
   rdfabian_mgal2o4,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in Jager Mg2SiO4 data
  if (iset eq 48) then begin
   rdjager_mg2sio4,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in Jager MgSiO3 data
  if (iset eq 49) then begin
   rdjager_mgsio3,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in Zeidler TiO2 (Rutile)
  if (iset eq 50) then begin
   rdzeidler_tio2_rutile,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in Zeidler TiO2 (Rutile)
  if (iset eq 51) then begin
   rdzeidler_tio2_anatase,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in Posch TiO2 (Brookite)
  if (iset eq 52) then begin
   rdposch_tio2_brookite,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; *************************
; Supplementary set of indices

; Read in Kou imiginary indices (note that real indices are not present)
  if (iset eq 53) then begin
   rdkou,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   ifound=1
   ibothpos=0
   goto,jump1
  endif

; **
; Read in the Sinyuk desert dust
  if (iset eq 54) then begin
   rdsinyuk,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in Dingle SOA
  if (iset eq 55) then begin
   rddingle_soa,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the Zarzana soa proxy data (at one wavelength)
  if (iset eq 56) then begin
   rdzarzana_soa_proxy,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the Querry diesel soot (fairly coarse resolution)
  if (iset eq 57) then begin
   rdquerry_diesel_soot,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Read in the Niedziela h2so4 indices
  if (iset eq 58) then begin
   rdniedziela_h2so4,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   ifound=1
   goto,jump1
  endif

; **
; Read in the Biermann h2so4 indices
  if (iset eq 59) then begin

; The biermann indices
   rdbiermann_h2so4,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlinesr,wcmr,wavelengthr,rndat,$
   nlinesi,wcmi,wavelengthi,ridat,$
   ndifferent

; Since ndifferent eq 1, will put on common grid
   if (ndifferent eq 1) then begin
    samewave,nopr,iout,$
    nlines,wcm,wavelength,$
    nlinesr,wcmr,wavelengthr,rndat,$
    nlinesi,wcmi,wavelengthi,ridat
   endif

   ifound=1
   goto,jump1
  endif

; **
; Read in the Palmer and Williams h2so4 indices
  if (iset eq 60) then begin
   rdpalmer,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   ifound=1
   goto,jump1
  endif

; **
; Read in the Norman hno3 indices
  if (iset eq 61) then begin
   rdnorman_hno3,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   ifound=1
   goto,jump1
  endif

; **
; Read in the Biermann hno3 indices
  if (iset eq 62) then begin

; The biermann indices
   rdbiermann_hno3,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlinesr,wcmr,wavelengthr,rndat,$
   nlinesi,wcmi,wavelengthi,ridat,$
   ndifferent

; Since ndifferent eq 1, will put on common grid
   if (ndifferent eq 1) then begin
    samewave,nopr,iout,$
    nlines,wcm,wavelength,$
    nlinesr,wcmr,wavelengthr,rndat,$
    nlinesi,wcmi,wavelengthi,ridat
   endif

   ifound=1
   goto,jump1
  endif

; **
; Read in the Querry and Tyler hno3/h2o
  if (iset eq 63) then begin
   rdquerry_hno3,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   ifound=1
   goto,jump1
  endif

; **
; Read in the Remsberg_hno3 binary (also has h2so4 binary)
  if (iset eq 64) then begin
   rdremsberg_hno3,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   ifound=1
   goto,jump1
  endif

; **
; Read in the Hasenkopf organic haze data (at one wavelength)
  if (iset eq 65) then begin
   rdhasenkopf_organic_haze,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave
   goto,jump1
  endif

; **
; Found the indices
   jump1:mn=0

; *************************
; Make sure ridat is ge 0.0
   for i=0,nlines-1 do begin
     a1=ridat(i)
    if (a1 lt 0.0) then begin
     ridat(i)=0.0
    endif
   endfor

; **************************
; Specify by hand for test purposes
   itestcase=0
  if (itestcase eq 1) then begin
   for i=0,nlines-1 do begin
    rndat(i)=1.33
    ridat(i)=0.05
   endfor
  endif

    icheck=0
   if (icheck eq 1) then begin
    help,nlines
    help,wcm
    help,wavelength
    help,rndat
    help,ridat
    stop
   endif

; *************************
; Write out the original indices 
  if (iwrind eq 1) then begin
   wrindices_orig,nopr,iout,outdir,$
   nlines,wcm,wavelength,rndat,ridat,iwave,$
   lset
  endif

; *************************
; Graph the results
   if (igraphi eq 1) then begin

; The output ps graphics file
    fileps=strcompress(outdir+'gindexorig.ps')

; Open the output ps file
    set_plot, 'ps'
    device, /color, bits_per_pixel=8, file=fileps,$
     /portrait,/inch,ysize=9.0,xsize=7.0,xoffset=0.6,yoffset=1.0

; ****
      ngraphs=2
     titles=strarr(ngraphs)
     titles=['Real Index ','Imaginary Index']

      arrays=fltarr(nlines,ngraphs)
     for i=0,nlines-1 do begin
      arrays(i,0)=rndat(i)
      arrays(i,1)=ridat(i)
     endfor

     xvec=fltarr(nlines)
     yvec=fltarr(nlines)
     isym=intarr(nlines)

; Loop over the graphs
    for ii=0,ngraphs-1 do begin

      for i=0,nlines-1 do begin
        xvec(i)=wcm(i)
       if (iwave eq 2) then begin
        xvec(i)=1.0e4/wcm(i)
       endif
       yvec(i)=arrays(i,ii)
       isym(i)=4
      endfor

    if (iwave eq 1) then begin
     labelx='Wavenumber (cm-1)'
    endif
    if (iwave eq 2) then begin
     labelx='Wavelength (microns)'
    endif
    labely=titles(ii)
    title=lset

    xmin=min(xvec)
    xmax=max(xvec)
    ymin=min(yvec)
    ymax=max(yvec)

    ixlog=0
    iylog=0
    ioplot=1

    graphxy,iout,xvec,yvec,isym,nlines,labelx,labely,title,$
    xmin,xmax,ymin,ymax,ixlog,iylog,ioplot,fileps

    endfor
; Loop over the graphs

; Close the output ps graphics file
    print,' rdindices: wrote to ',fileps
    device,/close

   endif
; *************************
  return
  end
