  pro graphlines,nopr,iout,ii,$
  nlines,num1,xvec,yvec,veccolor,isym,$
  labelx,labely,title0,title1,title2,$
  xmin,xmax,ymin,ymax,iyreverse,$
  titlej,words,vecj,x0,y0,iwrlabel

; /ur/massie/aerind/graphlines83.pro

; ****************************
; Load the color table
  loadct,26

; Graph the data
  !P.MULTI=[0,1,1]

; Bold fonts
  !P.font=0

  xm=0.0

; Will have 2 graphs per page
  if (ii eq 0) then begin
   x1a=0.15
   x2a=0.45
   y1a=0.30
   y2a=0.70
  endif
  if (ii eq 1) then begin
   x1a=0.55
   x2a=0.85
   y1a=0.30
   y2a=0.70
  endif

; ****
  if (iyreverse eq 0) then begin
   cs=1.0
   cth=1.5
  plot,xvec,yvec,xtitle=labelx,ytitle=labely,title=title1,$
  xrange=[xmin,xmax],$
  yrange=[ymin,ymax],$
  charsize=cs,charthick=cth,$
  xcharsize=cs,xthick=cth,$
  ycharsize=cs,ythick=cth,$
  thick=3,$
  xmargin=[xm,xm],ymargin=[xm,xm],$
  position=[x1a,y1a,x2a,y2a],$
  /NOERASE,$
  /NODATA
  endif

  if (iyreverse eq 1) then begin
   cs=1.0
   cth=1.5
  plot,xvec,yvec,xtitle=labelx,ytitle=labely,title=title1,$
  xrange=[xmin,xmax],$
  yrange=[ymax,ymin],$
  charsize=cs,charthick=cth,$
  xcharsize=cs,xthick=cth,$
  ycharsize=cs,ythick=cth,$
  thick=3,$
  xmargin=[xm,xm],ymargin=[xm,xm],$
  position=[x1a,y1a,x2a,y2a],$
  /NOERASE,$
  /NODATA
  endif

; This does the individual lines
   xvec1=fltarr(num1)
   yvec1=fltarr(num1)
  for j=0,nlines-1 do begin
   for i=0,num1-1 do begin
    xvec1(i)=xvec(i,j)
    yvec1(i)=yvec(i,j)
   endfor
   clr=vecj(j)
   oplot,xvec1,yvec1,thick=3,color=clr
  endfor

; ****
; Put the two (or more) sets of data points on the graph
  for i=0,num1-1 do begin
  for j=0,nlines-1 do begin
   x=xvec(i,j)
   y=yvec(i,j)
   c=veccolor(i,j)
   jsym=isym(i,j)
   sz=1.0
   if ((x ge xmin) and (x le xmax)) then begin
   if ((y ge ymin) and (y le ymax)) then begin
    plots,x,y,COLOR=c,PSYM=jsym,SYMSIZE=sz,THICK=3.0,/DATA
   endif
   endif
  endfor
  endfor
   
; *****
; Write out labels
  if (iwrlabel eq 1) then begin
     eps=0.03

    cthick=3.0

    x2=x0-0.05
    y2=y0+2.0*eps
    xyouts,x2,y2,title0,CHARSIZE=1.5,/NORMAL,ALIGNMENT=0.5,$
    CHARTHICK=cthick

    x2=x0-0.05
    y2=y0+1.0*eps
    xyouts,x2,y2,title2,CHARSIZE=1.5,/NORMAL,ALIGNMENT=0.5,$
    CHARTHICK=cthick

    y=y0
    x2=x0-0.05
    y2=y0
    xyouts,x2,y2,titlej,CHARSIZE=1.5,COLOR=c2,/NORMAL,ALIGNMENT=0.5,$
    CHARTHICK=cthick

   if (ii eq 1) then begin
     y=y-0.01
    for i=0,nlines-1 do begin
     wordsxy=words(i)
     x=x0
     y=y-eps
     c2=vecj(i)
     xyouts,x,y,wordsxy,CHARSIZE=2.0,COLOR=c2,/NORMAL,ALIGNMENT=0.5,$
     CHARTHICK=cthick
      x2=x-0.25
      y2=y+0.01
     jsym=isym(0,i)
     plots,x2,y2,COLOR=c2,PSYM=jsym,SYMSIZE=2.0,THICK=cthick,/NORMAL
    endfor
   endif

  endif

; *****
  return
  end
