  pro grmultboth,noprg,iout,fileps,icase,$
  nwave,nfiles,wavecm,wavelength,rn,ri,$
  curvelabels,titlegr,fsavereal,fsaveimag

; Graph the real and imaginary data on the same page

; The user may need to change the x and y values (0 to 1) on the page
; of the curve labels

; ****************
   set_plot, 'ps'
  device, /color, bits_per_pixel=8, file=fileps,$
   /portrait,/inch,ysize=9.0,xsize=7.0,xoffset=0.6,yoffset=1.0

; specify the color palette
; see pg 16-10 of the user's guide
   icolor=1
  if (icolor eq 1) then begin
   loadct, 26
  endif
  if (icolor eq 0) then begin
   loadct, 0
  endif

; For bold type
  !P.font=0

; specify the character size for the labels
  csizet=1.5
  csizel=1.0

; have graphs plus the color bar
; [ignore,horizontal,vertical]
   nmult=2
  !P.MULTI=[0,1,nmult]

  xm=4

; ************
  for icase=1,2 do begin

; **
; See grmultisets.pro
;  save,npts,xvec,yvec,veccolor,isymn,clrval,$
;  nlines,xvecn,yvecn,igraphdat,mpts,$
;  labelx,labely,title,$
;  xmin,xmax,ymin,ymax,$
;  x1a,y1a,x2a,y2a,$
;  igrwords,grwords,xwords,ywords,wordc,$
;  xr1,xr2,yr1,yr2,$
;  file=fsaveset

   if (icase eq 1) then begin
    file=fsavereal
   endif
   if (icase eq 2) then begin
    file=fsaveimag
   endif
   restore,file

   titlegnew=title
   title=' '

; Real indices
; The user may need to change the x and y values (0 to 1) on the page
; of the curve labels
   if (icase eq 1) then begin

    isetb=1
   if (isetb eq 1) then begin
    x1a=0.15
    x2a=0.45
    y1a=0.50
    y2a=0.80
   endif

     yval=0.55
     eps=0.05
    for i=0,nlines-1 do begin
     grwords(i)=curvelabels(i)
     xwords(i)=0.40
     yval=yval-eps
     ywords(i)=yval
     wordc(i)=clrval(i)
    endfor

    igrwords=0

   endif

; Imaginary indices
; The user may need to change the x and y values (0 to 1) on the page
; of the curve labels
   if (icase eq 2) then begin

    isetb=1
    xeps=0.02
   if (isetb eq 1) then begin
    x1a=0.55+xeps
    x2a=0.85+xeps
    y1a=0.50
    y2a=0.80
   endif

       yval=0.77
     eps=0.03
    for i=0,nlines-1 do begin
     grwords(i)=curvelabels(i)
       xwords(i)=0.65
     yval=yval-eps
     ywords(i)=yval
     wordc(i)=clrval(i)
    endfor

    igrwords=1

   endif

; **
; Graph the multiple set of lines
    noprg=0
   graphmultisets,noprg,iout,$
   npts,xvec,yvec,veccolor,isymn,clrval,$
   nlines,xvecn,yvecn,igraphdat,mpts,$
   labelx,labely,title,$
   xmin,xmax,ymin,ymax,$
   x1a,y1a,x2a,y2a,$
   igrwords,grwords,xwords,ywords,wordc,$
   xr1,xr2,yr1,yr2

   endfor
; Loop over the two graphs on the same page

; **************
; Put title on page
     x=0.5
     y=y2a+0.02
     c2=0.0
     cs2=1.5
     cth=3.0
    xyouts,x,y,titlegnew,CHARSIZE=cs2,COLOR=c2,/NORMAL,ALIGNMENT=0.5,$
     CHARTHICK=cth

; **************
  device,/close
  print,fileps

; ******************************
  return
  end
