   pro rdjovanovicpluto,nopr,iout,filnm,$
   ntext,text,$
   nlines,wcm,wavelength,rndat,ridat,rnerr,rierr

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file is filnm

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnfiles=ncdf_varid(nc_id,'nfiles')
  idnwave=ncdf_varid(nc_id,'nwave')

  idwcm=ncdf_varid(nc_id,'wcm')
  idwavelength=ncdf_varid(nc_id,'wavelength')
  idrn=ncdf_varid(nc_id,'rn')
  idri=ncdf_varid(nc_id,'ri')

  idtext=ncdf_varid(nc_id,'text')
  idplutostrs=ncdf_varid(nc_id,'plutostrs')

  idn70=ncdf_varid(nc_id,'n70')
  idn13=ncdf_varid(nc_id,'n13')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idn13,n13
  ncdf_varget,nc_id,idnfiles,nfiles
  ncdf_varget,nc_id,idnwave,nwave

  ncdf_varget,nc_id,idwcm,wcm
  ncdf_varget,nc_id,idwavelength,wavelength
  ncdf_varget,nc_id,idrn,rn
  ncdf_varget,nc_id,idri,ri

  text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; plutostrs=strarr(n13)
; ncdf_varget,nc_id,idplutostrs,plutostrs
; plutostrs=string(plutostrs)

   plutostrs=strarr(nfiles)
   plutostrs=strarr(nfiles)
;           '1234567890123'
   plutostrs=['Pluto aerosol']

; ****
; Close the data set
  ncdf_close,nc_id

; ****
   ihelp=0
  if (ihelp eq 1) then begin
   help,rn
   help,ri
   help,wcm
   help,wavelength
   help,nwave
   help,ntext
   help,text
   help,plutostrs
; RN              FLOAT     = Array[367]
; RI              FLOAT     = Array[367]
; WCM             FLOAT     = Array[367]
; WAVELENGTH      FLOAT     = Array[367]
; NWAVE           INT       =      367
; NTEXT           INT       =       14
; TEXT            STRING    = Array[14]
; PLUTOSTRS       STRING    = Array[1]
   stop
  endif

; *****
  print,'  '
  print,'  Pluto aerosol'

; ***
   text2=string(plutostrs)
;  lset=strcompress(lstrn+text2)

; *****
; Output values
   nlines=nwave

; Specify the indices
    jval=0
    rndat=fltarr(nwave)
    ridat=fltarr(nwave)
; have 0.0
    rnerr=fltarr(nwave)
    rierr=fltarr(nwave)
   for i=0,nwave-1 do begin
    rndat(i)=rn(i)
    ridat(i)=ri(i)
   endfor

; *****
    ntext=14
    text=strarr(ntext)
;           '1234567890123456789012345678901234567890123456789012345678901234567890'
    text(0)='                                                                      '
    text(1)='  Data: Real and imaginary indices of Pluto tholins                   '
    text(2)='  from 0.27 to 2.1 microns                                            '
    text(3)='                                                                      '
    text(4)='  Reference:  Jovanović L, Gautier T, Broch L, Protopapa S,           '
    text(5)='  Bertrand T, Rannou P, Fayolle M, Quirico E, Johann L, Naciri A,     '
    text(6)='  Carrasco, N                                                         '
    text(7)='  Optical constants of Pluto aerosol analogues from UV to near-IR     '
    text(8)='  Icarus, 2021;362:114398                                             '

; Jovanović, L., Gautier, T., Broch, L., Protopapa, S., Bertrand, T., Rannou, P., Fayolle, M., Quirico, E., Johann, L., Naciri, A.E. and Carrasco, N., 2021. Optical constants of Pluto aerosol analogues from UV to near-IR. Icarus, 362, p.114398.

    text(9)='                                                                      '
    text(10)='  Email contact person: L. Jovanovic (lora.jovanpvic@latmos.ipsl.fr)  '
    text(11)='                                                                      '
    text(12)='  Format: 367 real indices (2x,f8.2,2x,f10.4,1(2x,f5.3))              '
    text(13)='          367 imaginary indices (2x,f8.2,2x,f10.4,1(1x,e10.3))        '

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdjovanovicpluto: filnm ',filnm
    printf,iout,'  '
    printf,iout,'  rdjovanovicpluto: next ',ntext
    printf,iout,'  rdjovanovicpluto: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdjovanovicpluto: nwave ',nwave
   printf,iout,'  rdjovanovicpluto: plutostrs ',plutostrs
   printf,iout,'  rdjovanovicpluto: i,wcm,wavelength,rndat and ridat'
   for i=0,nwave-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end
