   pro rdreed,nopr,iout,filnm,$
   ntext,text,$
   nlines,wcm,wavelength,rndat,ridat,rnerr,rierr

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file

; print,filnm
; stop

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')
  idnfiles=ncdf_varid(nc_id,'nfiles')
  idnwave=ncdf_varid(nc_id,'nwave')

; idnweights=ncdf_varid(nc_id,'nweights')
; idwhno3=ncdf_varid(nc_id,'whno3')

  idwcm=ncdf_varid(nc_id,'wcm')
  idwavelength=ncdf_varid(nc_id,'wavelength')
  idrn=ncdf_varid(nc_id,'rn')
  idri=ncdf_varid(nc_id,'ri')

  idtext=ncdf_varid(nc_id,'text')
  idvolcstrs=ncdf_varid(nc_id,'volcstrs')

  idn70=ncdf_varid(nc_id,'n70')
  idn10=ncdf_varid(nc_id,'n10')
  idn8=ncdf_varid(nc_id,'n8')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70
  ncdf_varget,nc_id,idn10,n10
  ncdf_varget,nc_id,idn8,n8
  ncdf_varget,nc_id,idnfiles,nfiles
  ncdf_varget,nc_id,idnwave,nwave

; ncdf_varget,nc_id,idnweights,nweights
; ncdf_varget,nc_id,idwhno3,whno3

  ncdf_varget,nc_id,idwcm,wcm
  ncdf_varget,nc_id,idwavelength,wavelength
  ncdf_varget,nc_id,idrn,rn
  ncdf_varget,nc_id,idri,ri

  text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

  volcstrs=strarr(n10,n8)
  ncdf_varget,nc_id,idvolcstrs,volcstrs
  volcstrs=string(volcstrs)

; ****
; Close the data set
  ncdf_close,nc_id

; ****
   ihelp=0
  if (ihelp eq 1) then begin
   help,rn
   help,ri
   help,wcm
   help,wavelength
   help,nwave
   help,ntext
   help,text
   help,volcstrs
   stop
; RN              FLOAT     = Array[1933, 8]
; RI              FLOAT     = Array[1933, 8]
; WCM             FLOAT     = Array[1933]
; WAVELENGTH      FLOAT     = Array[1933]
; NWAVE           INT       =     1933
; NTEXT           INT       =       22
; TEXT            STRING    = Array[22]
; VOLCSTRS        STRING    = Array[8]
  endif

; *****
   volcstrs=strarr(n8)
;            '1234567890','1234567890','1234567890','1234567890','1234567890','1234567890','1234567890'.'1234567890'
   volcstrs=['Asjka    0','ASO      1','Eyjaf_1  2','Eyjaf_2  3','Grimsvot 4','Nisyros  5','Spurr    6','Tongarir 7']

; *****
  print,'  '
  print,'  Reed Volcanic Ash '
  print,' ',volcstrs
  print,'  specify j (from 0 to 7)'
  read,j

  jval=j

; ***
   text2=string(volcstrs(j))
;  lset=strcompress(lstrn+text2)

; *****
; Output
   nlines=nwave

; Specify the indices
    rndat=fltarr(nwave)
    ridat=fltarr(nwave)
    rnerr=fltarr(nwave)
    rnerr=fltarr(nwave)
   for i=0,nwave-1 do begin
    rndat(i)=rn(i,j)
    ridat(i)=ri(i,j)
   endfor

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdreed: next ',ntext
    printf,iout,'  rdreed: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdreed: nlines ',nlines
   printf,iout,'  rdreed: volcstrs(j) ',volcstrs(j)
   printf,iout,'  rdreed: i,wcm,wavelength,rndat and ridat'
   for i=0,nwave-1 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end
