   pro rdstagg_carbon_flame,nopr,iout,indir,outdir,lstrn,iset,lset,$
   nlines,wcm,wavelength,rndat,ridat,iwave

; ***
; Read in the data from the netCDF file

; ***
; The input netCDF file
  fil=strarr(1)
  fil='stagg_carbon.nc'
  filnm=strcompress(indir+fil)

; Open the netCDF file
  nc_id=ncdf_open(filnm)

; ***
; Get variable ids
  idntext=ncdf_varid(nc_id,'ntext')

  idnpyro=ncdf_varid(nc_id,'npyro')
  idnamorphous=ncdf_varid(nc_id,'namorphous')
  idnpropane=ncdf_varid(nc_id,'npropane')
  idnsoot=ncdf_varid(nc_id,'nsoot')

  idntpyro=ncdf_varid(nc_id,'ntpyro')
  idntamorphous=ncdf_varid(nc_id,'ntamorphous')
  idntpropane=ncdf_varid(nc_id,'ntpropane')
  idntsoot=ncdf_varid(nc_id,'ntsoot')

  idtkpyro=ncdf_varid(nc_id,'tkpyro')
  idtkamorphous=ncdf_varid(nc_id,'tkamorphous')
  idtkpropane=ncdf_varid(nc_id,'tkpropane')
  idtksoot=ncdf_varid(nc_id,'tksoot')

  idwcmpyro=ncdf_varid(nc_id,'wcmpyro')
  idwcmamorphous=ncdf_varid(nc_id,'wcmamorphous')
  idwcmpropane=ncdf_varid(nc_id,'wcmpropane')
  idwcmsoot=ncdf_varid(nc_id,'wcmsoot')

  idwmicpyro=ncdf_varid(nc_id,'wmicpyro')
  idwmicamorphous=ncdf_varid(nc_id,'wmicamorphous')
  idwmicpropane=ncdf_varid(nc_id,'wmicpropane')
  idwmicsoot=ncdf_varid(nc_id,'wmicsoot')

  idrnpyro=ncdf_varid(nc_id,'rnpyro')
  idrnamorphous=ncdf_varid(nc_id,'rnamorphous')
  idrnpropane=ncdf_varid(nc_id,'rnpropane')
  idrnsoot=ncdf_varid(nc_id,'rnsoot')

  idripyro=ncdf_varid(nc_id,'ripyro')
  idriamorphous=ncdf_varid(nc_id,'riamorphous')
  idripropane=ncdf_varid(nc_id,'ripropane')
  idrisoot=ncdf_varid(nc_id,'risoot')

  idtext=ncdf_varid(nc_id,'text')
  idn70=ncdf_varid(nc_id,'n70')

; ***
; Get data
  ncdf_varget,nc_id,idntext,ntext
  ncdf_varget,nc_id,idn70,n70

  ncdf_varget,nc_id,idnpyro,npyro
  ncdf_varget,nc_id,idnamorphous,namorphous
  ncdf_varget,nc_id,idnpropane,npropane
  ncdf_varget,nc_id,idnsoot,nsoot

  ncdf_varget,nc_id,idntpyro,ntpyro
  ncdf_varget,nc_id,idntamorphous,ntamorphous
  ncdf_varget,nc_id,idntpropane,ntpropane
  ncdf_varget,nc_id,idntsoot,ntsoot

  ncdf_varget,nc_id,idtkpyro,tkpyro
  ncdf_varget,nc_id,idtkamorphous,tkamorphous
  ncdf_varget,nc_id,idtkpropane,tkpropane
  ncdf_varget,nc_id,idtksoot,tksoot

  ncdf_varget,nc_id,idwcmpyro,wcmpyro
  ncdf_varget,nc_id,idwcmamorphous,wcmamorphous
  ncdf_varget,nc_id,idwcmpropane,wcmpropane
  ncdf_varget,nc_id,idwcmsoot,wcmsoot

  ncdf_varget,nc_id,idwmicpyro,wmicpyro
  ncdf_varget,nc_id,idwmicamorphous,wmicamorphous
  ncdf_varget,nc_id,idwmicpropane,wmicpropane
  ncdf_varget,nc_id,idwmicsoot,wmicsoot

  ncdf_varget,nc_id,idrnpyro,rnpyro
  ncdf_varget,nc_id,idrnamorphous,rnamorphous
  ncdf_varget,nc_id,idrnpropane,rnpropane
  ncdf_varget,nc_id,idrnsoot,rnsoot

  ncdf_varget,nc_id,idripyro,ripyro
  ncdf_varget,nc_id,idriamorphous,riamorphous
  ncdf_varget,nc_id,idripropane,ripropane
  ncdf_varget,nc_id,idrisoot,risoot

; text=strarr(n70,ntext)
  ncdf_varget,nc_id,idtext,text
  text=string(text)

; ****
; Close the data set
  ncdf_close,nc_id

; *****
; Specify which set to work with
  print,'  Stagg carbon flane indices '
  print,'  iset=0,1,2,3 for pyro, amorphous, propane, soot'
  print,'  Specify iset'
  read,iset

  if (iset eq 0) then begin
    nt=ntpyro
    tk=fltarr(nt)
   for i=0,nt-1 do begin
    tk(i)=tkpyro(i)
   endfor
  endif

  if (iset eq 1) then begin
    nt=ntamorphous
    tk=fltarr(nt)
   for i=0,nt-1 do begin
    tk(i)=tkamorphous(i)
   endfor
  endif

  if (iset eq 2) then begin
    nt=ntpropane
    tk=fltarr(nt)
   for i=0,nt-1 do begin
    tk(i)=tkpropane(i)
   endfor
  endif

  if (iset eq 3) then begin
    nt=ntsoot
    tk=fltarr(nt)
   for i=0,nt-1 do begin
    tk(i)=tksoot(i)
   endfor
  endif

  print,'  These are the temperatures (in C) you can choose from'
  print,'  ',tk
  print,'  Specify temperature'
  read,tcval

  tcvalstr=strarr(1)
  tcvalstr=string(fix(tcval))

   diffmin=1.0e6
   jval=-99
  for j=0,nt-1 do begin
    diff=abs(tk(j)-tcval)
   if (diff lt diffmin) then begin
    jval=j
    diffmin=diff
    tcvalstr=string(fix(tk(j)))
   endif
  endfor

  lines2=intarr(8)
  lines2(0)=npyro
  lines2(1)=namorphous
  lines2(2)=npropane
  lines2(3)=nsoot

  nlines=intarr(1)
  nlines=lines2(iset)
  i1=0
  i2=nlines(0)-1
  nlines=i2+1

  rndat=fltarr(nlines)
  ridat=fltarr(nlines)
  wcm=fltarr(nlines)
  wavelength=fltarr(nlines)

; **
  if (iset eq 0) then begin
   for i=i1,i2 do begin
    rndat(i)=rnpyro(i,jval)
    ridat(i)=ripyro(i,jval)
    wcm(i)=wcmpyro(i)
    wavelength(i)=wmicpyro(i)
   endfor
   casestr=' pyro '
   goto,jump1
  endif

  if (iset eq 1) then begin
   for i=i1,i2 do begin
    rndat(i)=rnamorphous(i,jval)
    ridat(i)=riamorphous(i,jval)
    wcm(i)=wcmamorphous(i)
    wavelength(i)=wmicamorphous(i)
   endfor
   casestr=' amorphous '
   goto,jump1
  endif

  if (iset eq 2) then begin
   for i=i1,i2 do begin
    rndat(i)=rnpropane(i,jval)
    ridat(i)=ripropane(i,jval)
    wcm(i)=wcmpropane(i)
    wavelength(i)=wmicpropane(i)
   endfor
   casestr=' propane'
   goto,jump1
  endif

  if (iset eq 3) then begin
   for i=i1,i2 do begin
    rndat(i)=rnsoot(i,jval)
    ridat(i)=risoot(i,jval)
    wcm(i)=wcmsoot(i)
    wavelength(i)=wmicsoot(i)
   endfor
   casestr=' soot '
   goto,jump1
  endif

  jump1:mn=0

; ***
   lset=strcompress(lstrn+casestr+tcvalstr+' C')

; *****
  if (nopr eq 1) then begin

    printf,iout,'  '
    printf,iout,'  rdstagg_carbon_flame: text(i)'
   for i=0,ntext-1 do begin
    printf,iout,text(i)
   endfor

   printf,iout,'  '
   printf,iout,'  rdstagg_carbon_flame: i,wcm,wavelength,rndat and ridat'
   for i=i1,i2 do begin
    printf,iout,'  ',i,wcm(i),wavelength(i),rndat(i),ridat(i)
   endfor

  endif

; ******
  return
  end


